/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.ImmutableCollectors;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public final class Signature {
    private final String name;
    private final FunctionKind kind;
    private final List<TypeParameter> typeParameters;
    private final TypeSignature returnType;
    private final List<TypeSignature> argumentTypes;
    private final boolean variableArity;

    @JsonCreator
    public Signature(@JsonProperty(value="name") String name, @JsonProperty(value="kind") FunctionKind kind, @JsonProperty(value="typeParameters") List<TypeParameter> typeParameters, @JsonProperty(value="returnType") TypeSignature returnType, @JsonProperty(value="argumentTypes") List<TypeSignature> argumentTypes, @JsonProperty(value="variableArity") boolean variableArity) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(typeParameters, "typeParameters is null");
        this.name = name;
        this.kind = Objects.requireNonNull(kind, "type is null");
        this.typeParameters = ImmutableList.copyOf(typeParameters);
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        this.variableArity = variableArity;
    }

    public Signature(String name, FunctionKind kind, List<TypeParameter> typeParameters, String returnType, List<String> argumentTypes, boolean variableArity) {
        this(name, kind, typeParameters, TypeSignature.parseTypeSignature((String)returnType), Lists.transform(argumentTypes, TypeSignature::parseTypeSignature), variableArity);
    }

    public Signature(String name, FunctionKind kind, String returnType, List<String> argumentTypes) {
        this(name, kind, (List<TypeParameter>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)returnType), Lists.transform(argumentTypes, TypeSignature::parseTypeSignature), false);
    }

    public Signature(String name, FunctionKind kind, String returnType, String ... argumentTypes) {
        this(name, kind, returnType, (List<String>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public Signature(String name, FunctionKind kind, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        this(name, kind, (List<TypeParameter>)ImmutableList.of(), returnType, argumentTypes, false);
    }

    public Signature(String name, FunctionKind kind, TypeSignature returnType, TypeSignature ... argumentTypes) {
        this(name, kind, returnType, (List<TypeSignature>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalOperator(OperatorType operator, Type returnType, List<? extends Type> argumentTypes) {
        return Signature.internalScalarFunction(FunctionRegistry.mangleOperatorName(operator.name()), returnType.getTypeSignature(), (List)argumentTypes.stream().map(Type::getTypeSignature).collect(ImmutableCollectors.toImmutableList()));
    }

    public static Signature internalOperator(String name, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        return Signature.internalScalarFunction(FunctionRegistry.mangleOperatorName(name), returnType, argumentTypes);
    }

    public static Signature internalOperator(String name, TypeSignature returnType, TypeSignature ... argumentTypes) {
        return Signature.internalScalarFunction(FunctionRegistry.mangleOperatorName(name), returnType, (List<TypeSignature>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalScalarFunction(String name, String returnType, String ... argumentTypes) {
        return Signature.internalScalarFunction(name, returnType, (List<String>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalScalarFunction(String name, String returnType, List<String> argumentTypes) {
        return new Signature(name, FunctionKind.SCALAR, (List<TypeParameter>)ImmutableList.of(), returnType, argumentTypes, false);
    }

    public static Signature internalScalarFunction(String name, TypeSignature returnType, TypeSignature ... argumentTypes) {
        return Signature.internalScalarFunction(name, returnType, (List<TypeSignature>)ImmutableList.copyOf((Object[])argumentTypes));
    }

    public static Signature internalScalarFunction(String name, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        return new Signature(name, FunctionKind.SCALAR, (List<TypeParameter>)ImmutableList.of(), returnType, argumentTypes, false);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public FunctionKind getKind() {
        return this.kind;
    }

    @JsonProperty
    public TypeSignature getReturnType() {
        return this.returnType;
    }

    @JsonProperty
    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    @JsonProperty
    public boolean isVariableArity() {
        return this.variableArity;
    }

    @JsonProperty
    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.kind, this.typeParameters, this.returnType, this.argumentTypes, this.variableArity});
    }

    Signature withAlias(String name) {
        return new Signature(name, this.kind, this.typeParameters, this.getReturnType(), this.getArgumentTypes(), this.variableArity);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Signature other = (Signature)obj;
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.kind, (Object)other.kind) && Objects.equals(this.typeParameters, other.typeParameters) && Objects.equals(this.returnType, other.returnType) && Objects.equals(this.argumentTypes, other.argumentTypes) && Objects.equals(this.variableArity, other.variableArity);
    }

    public String toString() {
        return this.name + (this.typeParameters.isEmpty() ? "" : "<" + Joiner.on((String)",").join(this.typeParameters) + ">") + "(" + Joiner.on((String)",").join(this.argumentTypes) + "):" + this.returnType;
    }

    @Nullable
    public Map<String, Type> bindTypeParameters(Type returnType, List<? extends Type> types, boolean allowCoercion, TypeManager typeManager) {
        HashMap<String, Type> boundParameters = new HashMap<String, Type>();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TypeParameter parameter : this.typeParameters) {
            builder.put((Object)parameter.getName(), (Object)parameter);
        }
        ImmutableMap parameters = builder.build();
        if (!Signature.matchAndBind(boundParameters, (Map<String, TypeParameter>)parameters, this.returnType, returnType, allowCoercion, typeManager)) {
            return null;
        }
        if (!Signature.matchArguments(boundParameters, (Map<String, TypeParameter>)parameters, this.argumentTypes, types, allowCoercion, this.variableArity, typeManager)) {
            return null;
        }
        Preconditions.checkState((boolean)boundParameters.keySet().equals(parameters.keySet()), (String)"%s matched arguments %s, but type parameters %s are still unbound", (Object[])new Object[]{this, types, Sets.difference((Set)parameters.keySet(), boundParameters.keySet())});
        return boundParameters;
    }

    @Nullable
    public Map<String, Type> bindTypeParameters(List<? extends Type> types, boolean allowCoercion, TypeManager typeManager) {
        HashMap<String, Type> boundParameters = new HashMap<String, Type>();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TypeParameter parameter : this.typeParameters) {
            builder.put((Object)parameter.getName(), (Object)parameter);
        }
        ImmutableMap parameters = builder.build();
        if (!Signature.matchArguments(boundParameters, (Map<String, TypeParameter>)parameters, this.argumentTypes, types, allowCoercion, this.variableArity, typeManager)) {
            return null;
        }
        Preconditions.checkState((boolean)boundParameters.keySet().equals(parameters.keySet()), (String)"%s matched arguments %s, but type parameters %s are still unbound", (Object[])new Object[]{this, types, Sets.difference((Set)parameters.keySet(), boundParameters.keySet())});
        return boundParameters;
    }

    private static boolean matchArguments(Map<String, Type> boundParameters, Map<String, TypeParameter> parameters, List<TypeSignature> argumentTypes, List<? extends Type> types, boolean allowCoercion, boolean varArgs, TypeManager typeManager) {
        if (varArgs ? types.size() < argumentTypes.size() - 1 : argumentTypes.size() != types.size()) {
            return false;
        }
        if (varArgs && types.size() >= argumentTypes.size()) {
            Optional<Type> superType = FunctionRegistry.getCommonSuperType(types.subList(argumentTypes.size() - 1, types.size()));
            if (!superType.isPresent()) {
                return false;
            }
            if (!Signature.matchAndBind(boundParameters, parameters, argumentTypes.get(argumentTypes.size() - 1), superType.get(), allowCoercion, typeManager)) {
                return false;
            }
        }
        for (int i = 0; i < types.size(); ++i) {
            Type type;
            TypeSignature typeSignature = argumentTypes.get(Math.min(i, argumentTypes.size() - 1));
            if (Signature.matchAndBind(boundParameters, parameters, typeSignature, type = types.get(i), allowCoercion, typeManager)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchAndBind(Map<String, Type> boundParameters, Map<String, TypeParameter> typeParameters, TypeSignature parameter, Type type, boolean allowCoercion, TypeManager typeManager) {
        if (boundParameters.containsKey(parameter.getBase())) {
            Preconditions.checkArgument((boolean)parameter.getParameters().isEmpty(), (Object)"Unexpected parameteric type");
            if (allowCoercion) {
                if (FunctionRegistry.canCoerce(type, boundParameters.get(parameter.getBase()))) {
                    return true;
                }
                if (FunctionRegistry.canCoerce(boundParameters.get(parameter.getBase()), type) && typeParameters.get(parameter.getBase()).canBind(type)) {
                    boundParameters.put(parameter.getBase(), type);
                    return true;
                }
                return false;
            }
            return type.equals(boundParameters.get(parameter.getBase()));
        }
        if (!parameter.getParameters().isEmpty()) {
            if (type.getTypeParameters().size() != parameter.getParameters().size()) {
                return false;
            }
            for (int i = 0; i < parameter.getParameters().size(); ++i) {
                Type componentType = (Type)type.getTypeParameters().get(i);
                TypeSignature componentSignature = (TypeSignature)parameter.getParameters().get(i);
                if (Signature.matchAndBind(boundParameters, typeParameters, componentSignature, componentType, allowCoercion, typeManager)) continue;
                return false;
            }
        }
        if (typeParameters.containsKey(parameter.getBase())) {
            TypeParameter typeParameter = typeParameters.get(parameter.getBase());
            if (!typeParameter.canBind(type)) {
                return false;
            }
            boundParameters.put(parameter.getBase(), type);
            return true;
        }
        if (!parameter.getParameters().isEmpty()) {
            return type.getTypeSignature().getBase().equals(parameter.getBase());
        }
        if (allowCoercion) {
            return FunctionRegistry.canCoerce(type, typeManager.getType(TypeSignature.parseTypeSignature((String)parameter.getBase())));
        }
        return type.equals(typeManager.getType(TypeSignature.parseTypeSignature((String)parameter.getBase())));
    }

    public static TypeParameter withVariadicBound(String name, String variadicBound) {
        return new TypeParameter(name, false, false, variadicBound);
    }

    public static TypeParameter comparableWithVariadicBound(String name, String variadicBound) {
        return new TypeParameter(name, true, false, variadicBound);
    }

    public static TypeParameter typeParameter(String name) {
        return new TypeParameter(name, false, false, null);
    }

    public static TypeParameter comparableTypeParameter(String name) {
        return new TypeParameter(name, true, false, null);
    }

    public static TypeParameter orderableTypeParameter(String name) {
        return new TypeParameter(name, false, true, null);
    }
}

