/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.JsonTypeIdResolver;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public abstract class AbstractTypedJacksonModule<T>
extends SimpleModule {
    private final String typeProperty;

    protected AbstractTypedJacksonModule(Class<T> baseClass, String typeProperty, JsonTypeIdResolver<T> typeIdResolver) {
        super(baseClass.getSimpleName() + "Module", Version.unknownVersion());
        this.typeProperty = typeProperty;
        InternalTypeResolver typeResolver = new InternalTypeResolver(typeIdResolver);
        this.addSerializer(baseClass, (JsonSerializer)new InternalTypeSerializer(baseClass, typeResolver));
        this.addDeserializer(baseClass, (JsonDeserializer)new InternalTypeDeserializer(baseClass, typeResolver));
    }

    class InternalTypeResolver
    implements TypeIdResolver {
        private final JsonTypeIdResolver<Object> typeIdResolver;
        private final LoadingCache<Class<?>, SimpleType> simpleTypes;

        InternalTypeResolver(JsonTypeIdResolver<Object> typeIdResolver) {
            this.typeIdResolver = Objects.requireNonNull(typeIdResolver, "typeIdResolver is null");
            this.simpleTypes = CacheBuilder.newBuilder().weakKeys().weakValues().build(new CacheLoader<Class<?>, SimpleType>(){

                public SimpleType load(Class<?> typeClass) throws Exception {
                    return SimpleType.construct(typeClass);
                }
            });
        }

        public void init(JavaType baseType) {
        }

        public String idFromValue(Object value) {
            Objects.requireNonNull(value, "value is null");
            return this.idFromValueAndType(value, value.getClass());
        }

        public String idFromValueAndType(Object value, Class<?> suggestedType) {
            Objects.requireNonNull(value, "value is null");
            String type = this.typeIdResolver.getId(value);
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown class %s", (Object[])new Object[]{suggestedType.getSimpleName()});
            return type;
        }

        public String idFromBaseType() {
            throw new UnsupportedOperationException();
        }

        public JavaType typeFromId(String id) {
            Objects.requireNonNull(id, "id is null");
            Class<Object> typeClass = this.typeIdResolver.getType(id);
            Preconditions.checkArgument((typeClass != null ? 1 : 0) != 0, (String)"Unknown type id %s", (Object[])new Object[]{id});
            return (JavaType)this.simpleTypes.getUnchecked(typeClass);
        }

        public JsonTypeInfo.Id getMechanism() {
            return JsonTypeInfo.Id.NAME;
        }
    }

    public class InternalTypeSerializer
    extends StdSerializer<T> {
        private final TypeSerializer typeSerializer;
        private final Cache<Class<?>, JsonSerializer<Object>> serializerCache;

        InternalTypeSerializer(Class<T> baseClass, TypeIdResolver typeIdResolver) {
            super(baseClass);
            this.serializerCache = CacheBuilder.newBuilder().build();
            this.typeSerializer = new AsPropertyTypeSerializer(typeIdResolver, null, AbstractTypedJacksonModule.this.typeProperty);
        }

        public void serialize(final T value, JsonGenerator jsonGenerator, final SerializerProvider serializerProvider) throws IOException {
            if (value == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
            } else {
                try {
                    JsonSerializer serializer = (JsonSerializer)this.serializerCache.get(value.getClass(), (Callable)new Callable<JsonSerializer<Object>>(){

                        @Override
                        public JsonSerializer<Object> call() throws Exception {
                            return BeanSerializerFactory.instance.createSerializer(serializerProvider, serializerProvider.constructType(value.getClass()));
                        }
                    });
                    serializer.serializeWithType(value, jsonGenerator, serializerProvider, this.typeSerializer);
                }
                catch (ExecutionException e) {
                    Throwables.propagateIfInstanceOf((Throwable)e.getCause(), IOException.class);
                    Throwables.propagateIfInstanceOf((Throwable)e.getCause(), JsonGenerationException.class);
                    throw Throwables.propagate((Throwable)e.getCause());
                }
            }
        }
    }

    public class InternalTypeDeserializer
    extends StdDeserializer<T> {
        private final TypeDeserializer typeDeserializer;

        InternalTypeDeserializer(Class<T> baseClass, TypeIdResolver typeIdResolver) {
            super(baseClass);
            this.typeDeserializer = new AsPropertyTypeDeserializer((JavaType)SimpleType.construct(baseClass), typeIdResolver, AbstractTypedJacksonModule.this.typeProperty, false, null);
        }

        public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this.typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
        }
    }
}

