/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.HashPagePartitionFunction;
import com.facebook.presto.PagePartitionFunction;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;

public class HashPartitionFunctionGenerator
implements BiFunction<Integer, Integer, PagePartitionFunction> {
    private final List<Integer> partitionChannels;
    private final Optional<Integer> hashChannel;
    private final List<Type> types;
    private final PlanFragment.NullPartitioning nullPartitioning;

    public HashPartitionFunctionGenerator(PlanFragment fragment) {
        Objects.requireNonNull(fragment, "fragment is null");
        Preconditions.checkState((fragment.getOutputPartitioning() == PlanFragment.OutputPartitioning.HASH ? 1 : 0) != 0, (Object)"fragment is not hash partitioned");
        this.partitionChannels = (List)fragment.getPartitionBy().get().stream().map(symbol -> fragment.getOutputLayout().indexOf(symbol)).collect(ImmutableCollectors.toImmutableList());
        this.hashChannel = fragment.getHash().map(fragment.getOutputLayout()::indexOf);
        this.types = fragment.getTypes();
        this.nullPartitioning = fragment.getNullPartitionPolicy().get();
    }

    public HashPartitionFunctionGenerator(List<Integer> partitionChannels, Optional<Integer> hashChannel, List<Type> types, PlanFragment.NullPartitioning nullPartitioning) {
        this.partitionChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionChannels, "partitionChannels is null"));
        this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.nullPartitioning = Objects.requireNonNull(nullPartitioning, "nullPartitioning is null");
    }

    @Override
    public PagePartitionFunction apply(Integer partition, Integer partitionCount) {
        return new HashPagePartitionFunction(partition, partitionCount, this.partitionChannels, this.hashChannel, this.types, this.nullPartitioning);
    }
}

