/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.SharedBufferInfo;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@Immutable
public class TaskInfo {
    public static final long STARTING_VERSION = 1L;
    public static final long MIN_VERSION = 0L;
    public static final long MAX_VERSION = Long.MAX_VALUE;
    private final TaskId taskId;
    private final Optional<String> nodeInstanceId;
    private final long version;
    private final TaskState state;
    private final URI self;
    private final DateTime lastHeartbeat;
    private final SharedBufferInfo outputBuffers;
    private final Set<PlanNodeId> noMoreSplits;
    private final TaskStats stats;
    private final List<ExecutionFailureInfo> failures;

    @JsonCreator
    public TaskInfo(@JsonProperty(value="taskId") TaskId taskId, @JsonProperty(value="nodeInstanceId") Optional<String> nodeInstanceId, @JsonProperty(value="version") long version, @JsonProperty(value="state") TaskState state, @JsonProperty(value="self") URI self, @JsonProperty(value="lastHeartbeat") DateTime lastHeartbeat, @JsonProperty(value="outputBuffers") SharedBufferInfo outputBuffers, @JsonProperty(value="noMoreSplits") Set<PlanNodeId> noMoreSplits, @JsonProperty(value="stats") TaskStats stats, @JsonProperty(value="failures") List<ExecutionFailureInfo> failures) {
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.nodeInstanceId = Objects.requireNonNull(nodeInstanceId, "nodeInstanceId is null");
        this.version = version;
        this.state = Objects.requireNonNull(state, "state is null");
        this.self = Objects.requireNonNull(self, "self is null");
        this.lastHeartbeat = Objects.requireNonNull(lastHeartbeat, "lastHeartbeat is null");
        this.outputBuffers = Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        this.noMoreSplits = Objects.requireNonNull(noMoreSplits, "noMoreSplits is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.failures = failures != null ? ImmutableList.copyOf(failures) : ImmutableList.of();
    }

    @JsonProperty
    public TaskId getTaskId() {
        return this.taskId;
    }

    @JsonProperty
    public Optional<String> getNodeInstanceId() {
        return this.nodeInstanceId;
    }

    @JsonProperty
    public long getVersion() {
        return this.version;
    }

    @JsonProperty
    public TaskState getState() {
        return this.state;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    public DateTime getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    @JsonProperty
    public SharedBufferInfo getOutputBuffers() {
        return this.outputBuffers;
    }

    @JsonProperty
    public Set<PlanNodeId> getNoMoreSplits() {
        return this.noMoreSplits;
    }

    @JsonProperty
    public TaskStats getStats() {
        return this.stats;
    }

    @JsonProperty
    public List<ExecutionFailureInfo> getFailures() {
        return this.failures;
    }

    public TaskInfo summarize() {
        return new TaskInfo(this.taskId, this.nodeInstanceId, this.version, this.state, this.self, this.lastHeartbeat, this.outputBuffers, this.noMoreSplits, this.stats.summarize(), this.failures);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("state", (Object)this.state).toString();
    }
}

