/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.TaskSource;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.execution.SplitRunner;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskExecutor;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PartitionedOutputOperator;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskOutputOperator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.SetThreadName;
import io.airlift.units.Duration;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class SqlTaskExecution {
    private final TaskId taskId;
    private final TaskStateMachine taskStateMachine;
    private final TaskContext taskContext;
    private final SharedBuffer sharedBuffer;
    private final TaskExecutor.TaskHandle taskHandle;
    private final TaskExecutor taskExecutor;
    private final Executor notificationExecutor;
    private final QueryMonitor queryMonitor;
    private final List<WeakReference<Driver>> drivers = new CopyOnWriteArrayList<WeakReference<Driver>>();
    private final AtomicInteger remainingDrivers = new AtomicInteger();
    @GuardedBy(value="this")
    private final ConcurrentMap<PlanNodeId, TaskSource> unpartitionedSources = new ConcurrentHashMap<PlanNodeId, TaskSource>();
    @GuardedBy(value="this")
    private long maxAcknowledgedSplit = Long.MIN_VALUE;
    private final PlanNodeId partitionedSourceId;
    private final DriverSplitRunnerFactory partitionedDriverFactory;
    private final List<DriverSplitRunnerFactory> unpartitionedDriverFactories;

    public static SqlTaskExecution createSqlTaskExecution(TaskStateMachine taskStateMachine, TaskContext taskContext, SharedBuffer sharedBuffer, PlanFragment fragment, List<TaskSource> sources, LocalExecutionPlanner planner, TaskExecutor taskExecutor, Executor notificationExecutor, QueryMonitor queryMonitor) {
        SqlTaskExecution task = new SqlTaskExecution(taskStateMachine, taskContext, sharedBuffer, fragment, planner, taskExecutor, queryMonitor, notificationExecutor);
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{task.getTaskId()});){
            task.start();
            task.addSources(sources);
            SqlTaskExecution sqlTaskExecution = task;
            return sqlTaskExecution;
        }
    }

    private SqlTaskExecution(TaskStateMachine taskStateMachine, TaskContext taskContext, SharedBuffer sharedBuffer, PlanFragment fragment, LocalExecutionPlanner planner, TaskExecutor taskExecutor, QueryMonitor queryMonitor, Executor notificationExecutor) {
        this.taskStateMachine = Objects.requireNonNull(taskStateMachine, "taskStateMachine is null");
        this.taskId = taskStateMachine.getTaskId();
        this.taskContext = Objects.requireNonNull(taskContext, "taskContext is null");
        this.sharedBuffer = Objects.requireNonNull(sharedBuffer, "sharedBuffer is null");
        this.taskExecutor = Objects.requireNonNull(taskExecutor, "driverExecutor is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            List<DriverFactory> driverFactories;
            try {
                OutputFactory outputOperatorFactory;
                switch (fragment.getOutputPartitioning()) {
                    case NONE: {
                        outputOperatorFactory = new TaskOutputOperator.TaskOutputFactory(sharedBuffer);
                        break;
                    }
                    case HASH: 
                    case ROUND_ROBIN: {
                        outputOperatorFactory = new PartitionedOutputOperator.PartitionedOutputFactory(sharedBuffer);
                        break;
                    }
                    default: {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("OutputPartitioning %s is not supported", new Object[]{fragment.getOutputPartitioning()}));
                    }
                }
                LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = planner.plan(taskContext.getSession(), fragment.getRoot(), fragment.getOutputLayout(), fragment.getSymbols(), fragment.getDistribution(), outputOperatorFactory);
                driverFactories = localExecutionPlan.getDriverFactories();
            }
            catch (Throwable e) {
                taskStateMachine.failed(e);
                throw Throwables.propagate((Throwable)e);
            }
            DriverSplitRunnerFactory partitionedDriverFactory = null;
            ImmutableList.Builder unpartitionedDriverFactories = ImmutableList.builder();
            for (DriverFactory driverFactory : driverFactories) {
                if (driverFactory.getSourceIds().contains(fragment.getPartitionedSource())) {
                    Preconditions.checkState((partitionedDriverFactory == null ? 1 : 0) != 0, (Object)"multiple partitioned sources are not supported");
                    partitionedDriverFactory = new DriverSplitRunnerFactory(driverFactory);
                    continue;
                }
                unpartitionedDriverFactories.add((Object)new DriverSplitRunnerFactory(driverFactory));
            }
            this.unpartitionedDriverFactories = unpartitionedDriverFactories.build();
            if (fragment.getDistribution() == PlanFragment.PlanDistribution.SOURCE) {
                Preconditions.checkArgument((partitionedDriverFactory != null ? 1 : 0) != 0, (Object)"Fragment is partitioned, but no partitioned driver found");
            }
            this.partitionedSourceId = fragment.getPartitionedSource();
            this.partitionedDriverFactory = partitionedDriverFactory;
            if (!taskStateMachine.getState().isDone()) {
                this.taskHandle = taskExecutor.addTask(this.taskId);
                taskStateMachine.addStateChangeListener(new RemoveTaskHandleWhenDone(taskExecutor, this.taskHandle));
            } else {
                this.taskHandle = null;
            }
            sharedBuffer.addStateChangeListener(new CheckTaskCompletionOnBufferFinish(this));
        }
    }

    private void start() {
        ArrayList<DriverSplitRunner> runners = new ArrayList<DriverSplitRunner>();
        for (DriverSplitRunnerFactory driverFactory : this.unpartitionedDriverFactories) {
            for (int i = 0; i < driverFactory.getDriverInstances(); ++i) {
                runners.add(driverFactory.createDriverRunner(null, false));
            }
            driverFactory.setNoMoreSplits();
        }
        this.enqueueDrivers(true, runners);
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public void addSources(List<TaskSource> sources) {
        Objects.requireNonNull(sources, "sources is null");
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (String)"Can not add sources while holding a lock on the %s", (Object[])new Object[]{this.getClass().getSimpleName()});
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            Map<PlanNodeId, TaskSource> updatedUnpartitionedSources = this.updateSources(sources);
            for (TaskSource source : updatedUnpartitionedSources.values()) {
                for (WeakReference<Driver> driverReference : this.drivers) {
                    Driver driver = (Driver)driverReference.get();
                    if (driver != null) {
                        driver.updateSource(source);
                        continue;
                    }
                    this.drivers.remove(driverReference);
                }
            }
            this.checkTaskCompletion();
        }
    }

    private synchronized Map<PlanNodeId, TaskSource> updateSources(List<TaskSource> sources) {
        HashMap<PlanNodeId, TaskSource> updatedUnpartitionedSources = new HashMap<PlanNodeId, TaskSource>();
        long newMaxAcknowledgedSplit = this.maxAcknowledgedSplit;
        for (TaskSource source : sources) {
            PlanNodeId sourceId = source.getPlanNodeId();
            if (sourceId.equals(this.partitionedSourceId)) {
                ImmutableList.Builder runners = ImmutableList.builder();
                for (ScheduledSplit scheduledSplit : source.getSplits()) {
                    if (scheduledSplit.getSequenceId() <= this.maxAcknowledgedSplit) continue;
                    runners.add((Object)this.partitionedDriverFactory.createDriverRunner(scheduledSplit, true));
                    newMaxAcknowledgedSplit = Math.max(scheduledSplit.getSequenceId(), newMaxAcknowledgedSplit);
                }
                this.enqueueDrivers(false, (List<DriverSplitRunner>)runners.build());
                if (!source.isNoMoreSplits()) continue;
                this.partitionedDriverFactory.setNoMoreSplits();
                continue;
            }
            for (ScheduledSplit scheduledSplit : source.getSplits()) {
                newMaxAcknowledgedSplit = Math.max(scheduledSplit.getSequenceId(), newMaxAcknowledgedSplit);
            }
            TaskSource currentSource = (TaskSource)this.unpartitionedSources.get(sourceId);
            TaskSource newSource = currentSource == null ? source : currentSource.update(source);
            if (newSource == currentSource) continue;
            this.unpartitionedSources.put(sourceId, newSource);
            updatedUnpartitionedSources.put(sourceId, newSource);
        }
        this.maxAcknowledgedSplit = newMaxAcknowledgedSplit;
        return updatedUnpartitionedSources;
    }

    private synchronized void enqueueDrivers(boolean forceRunSplit, List<DriverSplitRunner> runners) {
        List<ListenableFuture<?>> finishedFutures = this.taskExecutor.enqueueSplits(this.taskHandle, forceRunSplit, runners);
        Preconditions.checkState((finishedFutures.size() == runners.size() ? 1 : 0) != 0, (String)"Expected %s futures but got %s", (Object[])new Object[]{runners.size(), finishedFutures.size()});
        this.remainingDrivers.addAndGet(finishedFutures.size());
        for (int i = 0; i < finishedFutures.size(); ++i) {
            ListenableFuture<?> finishedFuture = finishedFutures.get(i);
            final DriverSplitRunner splitRunner = runners.get(i);
            Futures.addCallback(finishedFuture, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{SqlTaskExecution.this.taskId});){
                        SqlTaskExecution.this.remainingDrivers.decrementAndGet();
                        SqlTaskExecution.this.checkTaskCompletion();
                        SqlTaskExecution.this.queryMonitor.splitCompletionEvent(SqlTaskExecution.this.taskId, this.getDriverStats());
                    }
                }

                public void onFailure(Throwable cause) {
                    try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{SqlTaskExecution.this.taskId});){
                        SqlTaskExecution.this.taskStateMachine.failed(cause);
                        SqlTaskExecution.this.remainingDrivers.decrementAndGet();
                        SqlTaskExecution.this.queryMonitor.splitFailedEvent(SqlTaskExecution.this.taskId, this.getDriverStats(), cause);
                    }
                }

                private DriverStats getDriverStats() {
                    DriverContext driverContext = splitRunner.getDriverContext();
                    DriverStats driverStats = driverContext != null ? driverContext.getDriverStats() : new DriverStats();
                    return driverStats;
                }
            }, (Executor)this.notificationExecutor);
        }
    }

    public Set<PlanNodeId> getNoMoreSplits() {
        ImmutableSet.Builder noMoreSplits = ImmutableSet.builder();
        if (this.partitionedDriverFactory != null && this.partitionedDriverFactory.isNoMoreSplits()) {
            noMoreSplits.add((Object)this.partitionedSourceId);
        }
        for (TaskSource taskSource : this.unpartitionedSources.values()) {
            if (!taskSource.isNoMoreSplits()) continue;
            noMoreSplits.add((Object)taskSource.getPlanNodeId());
        }
        return noMoreSplits.build();
    }

    private synchronized void checkTaskCompletion() {
        if (this.taskStateMachine.getState().isDone()) {
            return;
        }
        if (this.partitionedDriverFactory != null && !this.partitionedDriverFactory.isNoMoreSplits()) {
            return;
        }
        if (this.remainingDrivers.get() != 0) {
            return;
        }
        this.sharedBuffer.setNoMorePages();
        if (!this.sharedBuffer.isFinished()) {
            return;
        }
        this.taskStateMachine.finished();
    }

    public void cancel() {
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            this.taskStateMachine.cancel();
        }
    }

    public void fail(Throwable cause) {
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            this.taskStateMachine.failed(cause);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("remainingDrivers", (Object)this.remainingDrivers).add("unpartitionedSources", this.unpartitionedSources).toString();
    }

    private static final class CheckTaskCompletionOnBufferFinish
    implements StateMachine.StateChangeListener<SharedBuffer.BufferState> {
        private final WeakReference<SqlTaskExecution> sqlTaskExecutionReference;

        public CheckTaskCompletionOnBufferFinish(SqlTaskExecution sqlTaskExecution) {
            this.sqlTaskExecutionReference = new WeakReference<SqlTaskExecution>(sqlTaskExecution);
        }

        @Override
        public void stateChanged(SharedBuffer.BufferState newState) {
            SqlTaskExecution sqlTaskExecution;
            if (newState == SharedBuffer.BufferState.FINISHED && (sqlTaskExecution = (SqlTaskExecution)this.sqlTaskExecutionReference.get()) != null) {
                sqlTaskExecution.checkTaskCompletion();
            }
        }
    }

    private static final class RemoveTaskHandleWhenDone
    implements StateMachine.StateChangeListener<TaskState> {
        private final TaskExecutor taskExecutor;
        private final TaskExecutor.TaskHandle taskHandle;

        private RemoveTaskHandleWhenDone(TaskExecutor taskExecutor, TaskExecutor.TaskHandle taskHandle) {
            this.taskExecutor = Objects.requireNonNull(taskExecutor, "taskExecutor is null");
            this.taskHandle = Objects.requireNonNull(taskHandle, "taskHandle is null");
        }

        @Override
        public void stateChanged(TaskState newState) {
            if (newState.isDone()) {
                this.taskExecutor.removeTask(this.taskHandle);
            }
        }
    }

    private static class DriverSplitRunner
    implements SplitRunner {
        private final DriverSplitRunnerFactory driverSplitRunnerFactory;
        private final DriverContext driverContext;
        @GuardedBy(value="this")
        private boolean closed;
        @Nullable
        private final ScheduledSplit partitionedSplit;
        @GuardedBy(value="this")
        private Driver driver;

        private DriverSplitRunner(DriverSplitRunnerFactory driverSplitRunnerFactory, DriverContext driverContext, @Nullable ScheduledSplit partitionedSplit) {
            this.driverSplitRunnerFactory = Objects.requireNonNull(driverSplitRunnerFactory, "driverFactory is null");
            this.driverContext = Objects.requireNonNull(driverContext, "driverContext is null");
            this.partitionedSplit = partitionedSplit;
        }

        public synchronized DriverContext getDriverContext() {
            if (this.driver == null) {
                return null;
            }
            return this.driver.getDriverContext();
        }

        @Override
        public synchronized boolean isFinished() {
            if (this.closed) {
                return true;
            }
            if (this.driver == null) {
                return false;
            }
            return this.driver.isFinished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListenableFuture<?> processFor(Duration duration) {
            Driver driver;
            DriverSplitRunner driverSplitRunner = this;
            synchronized (driverSplitRunner) {
                if (this.closed) {
                    return Futures.immediateFuture(null);
                }
                if (this.driver == null) {
                    this.driver = this.driverSplitRunnerFactory.createDriver(this.driverContext, this.partitionedSplit);
                }
                driver = this.driver;
            }
            return driver.processFor(duration);
        }

        @Override
        public String getInfo() {
            return this.partitionedSplit == null ? "" : this.partitionedSplit.getSplit().getInfo().toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Driver driver;
            DriverSplitRunner driverSplitRunner = this;
            synchronized (driverSplitRunner) {
                this.closed = true;
                driver = this.driver;
            }
            if (driver != null) {
                driver.close();
            }
        }
    }

    private class DriverSplitRunnerFactory {
        private final DriverFactory driverFactory;
        private final PipelineContext pipelineContext;
        private final AtomicInteger pendingCreation = new AtomicInteger();
        private final AtomicBoolean noMoreSplits = new AtomicBoolean();

        private DriverSplitRunnerFactory(DriverFactory driverFactory) {
            this.driverFactory = driverFactory;
            this.pipelineContext = SqlTaskExecution.this.taskContext.addPipelineContext(driverFactory.isInputDriver(), driverFactory.isOutputDriver());
        }

        private DriverSplitRunner createDriverRunner(@Nullable ScheduledSplit partitionedSplit, boolean partitioned) {
            this.pendingCreation.incrementAndGet();
            DriverContext driverContext = this.pipelineContext.addDriverContext(partitioned);
            return new DriverSplitRunner(this, driverContext, partitionedSplit);
        }

        private Driver createDriver(DriverContext driverContext, @Nullable ScheduledSplit partitionedSplit) {
            Driver driver = this.driverFactory.createDriver(driverContext);
            SqlTaskExecution.this.drivers.add(new WeakReference<Driver>(driver));
            if (partitionedSplit != null) {
                driver.updateSource(new TaskSource(SqlTaskExecution.this.partitionedSourceId, (Set<ScheduledSplit>)ImmutableSet.of((Object)partitionedSplit), true));
            }
            for (TaskSource source : SqlTaskExecution.this.unpartitionedSources.values()) {
                driver.updateSource(source);
            }
            this.pendingCreation.decrementAndGet();
            this.closeDriverFactoryIfFullyCreated();
            return driver;
        }

        private boolean isNoMoreSplits() {
            return this.noMoreSplits.get();
        }

        private void setNoMoreSplits() {
            this.noMoreSplits.set(true);
            this.closeDriverFactoryIfFullyCreated();
        }

        private void closeDriverFactoryIfFullyCreated() {
            if (this.isNoMoreSplits() && this.pendingCreation.get() <= 0) {
                this.driverFactory.close();
            }
        }

        public int getDriverInstances() {
            return this.driverFactory.getDriverInstances();
        }
    }
}

