/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SetSession;

public class SetSessionTask
implements DataDefinitionTask<SetSession> {
    @Override
    public String getName() {
        return "SET SESSION";
    }

    @Override
    public void execute(SetSession statement, Session session, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine) {
        Object objectValue;
        QualifiedName propertyName = statement.getName();
        if (propertyName.getParts().size() > 2) {
            throw new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Invalid session property '%s'", propertyName);
        }
        PropertyMetadata<?> propertyMetadata = metadata.getSessionPropertyManager().getSessionPropertyMetadata(propertyName.toString());
        if (propertyName.getParts().size() == 1) {
            accessControl.checkCanSetSystemSessionProperty(session.getIdentity(), (String)propertyName.getParts().get(0));
        } else if (propertyName.getParts().size() == 2) {
            accessControl.checkCanSetCatalogSessionProperty(session.getIdentity(), (String)propertyName.getParts().get(0), (String)propertyName.getParts().get(1));
        }
        Type type = propertyMetadata.getSqlType();
        try {
            objectValue = SessionPropertyManager.evaluatePropertyValue(statement.getValue(), type, session, metadata);
        }
        catch (SemanticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Unable to set session property '%s' to '%s': %s", propertyName, statement.getValue(), e.getMessage()));
        }
        String value = SessionPropertyManager.serializeSessionProperty(type, objectValue);
        metadata.getSessionPropertyManager().decodeProperty(propertyName.toString(), value, propertyMetadata.getJavaType());
        stateMachine.addSetSessionProperties(propertyName.toString(), value);
    }
}

