/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system.jdbc;

import com.facebook.presto.Session;
import com.facebook.presto.connector.system.jdbc.FilterUtil;
import com.facebook.presto.connector.system.jdbc.JdbcTable;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.ArrayType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class ColumnJdbcTable
extends JdbcTable {
    public static final SchemaTableName NAME = new SchemaTableName("jdbc", "columns");
    public static final ConnectorTableMetadata METADATA = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NAME).column("table_cat", (Type)VarcharType.VARCHAR).column("table_schem", (Type)VarcharType.VARCHAR).column("table_name", (Type)VarcharType.VARCHAR).column("column_name", (Type)VarcharType.VARCHAR).column("data_type", (Type)BigintType.BIGINT).column("type_name", (Type)VarcharType.VARCHAR).column("column_size", (Type)BigintType.BIGINT).column("buffer_length", (Type)BigintType.BIGINT).column("decimal_digits", (Type)BigintType.BIGINT).column("num_prec_radix", (Type)BigintType.BIGINT).column("nullable", (Type)BigintType.BIGINT).column("remarks", (Type)VarcharType.VARCHAR).column("column_def", (Type)VarcharType.VARCHAR).column("sql_data_type", (Type)BigintType.BIGINT).column("sql_datetime_sub", (Type)BigintType.BIGINT).column("char_octet_length", (Type)BigintType.BIGINT).column("ordinal_position", (Type)BigintType.BIGINT).column("is_nullable", (Type)VarcharType.VARCHAR).column("scope_catalog", (Type)VarcharType.VARCHAR).column("scope_schema", (Type)VarcharType.VARCHAR).column("scope_table", (Type)VarcharType.VARCHAR).column("source_data_type", (Type)BigintType.BIGINT).column("is_autoincrement", (Type)VarcharType.VARCHAR).column("is_generatedcolumn", (Type)VarcharType.VARCHAR).build();
    private final Metadata metadata;

    @Inject
    public ColumnJdbcTable(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata);
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public RecordCursor cursor(ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        Session session = FilterUtil.toSession(connectorSession);
        Optional<String> catalogFilter = FilterUtil.stringFilter(constraint, 0);
        Optional<String> schemaFilter = FilterUtil.stringFilter(constraint, 1);
        Optional<String> tableFilter = FilterUtil.stringFilter(constraint, 2);
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)METADATA);
        for (String catalog : FilterUtil.filter(this.metadata.getCatalogNames().keySet(), catalogFilter)) {
            QualifiedTablePrefix prefix = FilterUtil.tablePrefix(catalog, schemaFilter, tableFilter);
            for (Map.Entry<QualifiedTableName, List<ColumnMetadata>> entry : this.metadata.listTableColumns(session, prefix).entrySet()) {
                ColumnJdbcTable.addColumnRows(table, entry.getKey(), entry.getValue());
            }
        }
        return table.build().cursor();
    }

    private static void addColumnRows(InMemoryRecordSet.Builder builder, QualifiedTableName tableName, List<ColumnMetadata> columns) {
        int ordinalPosition = 1;
        for (ColumnMetadata column : columns) {
            if (column.isHidden()) continue;
            builder.addRow(new Object[]{tableName.getCatalogName(), tableName.getSchemaName(), tableName.getTableName(), column.getName(), ColumnJdbcTable.jdbcDataType(column.getType()), column.getType().getDisplayName(), 0, 0, ColumnJdbcTable.decimalDigits(column.getType()), 10, 2, column.getComment(), null, null, null, 0, ordinalPosition, "", null, null, null, null, null, null});
            ++ordinalPosition;
        }
    }

    private static int jdbcDataType(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return 16;
        }
        if (type.equals(BigintType.BIGINT)) {
            return -5;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return 8;
        }
        if (type.equals(VarcharType.VARCHAR)) {
            return -16;
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return -4;
        }
        if (type.equals(TimeType.TIME)) {
            return 92;
        }
        if (type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
            return 2013;
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return 93;
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            return 2014;
        }
        if (type.equals(DateType.DATE)) {
            return 91;
        }
        if (type instanceof ArrayType) {
            return 2003;
        }
        return 2000;
    }

    private static Integer decimalDigits(Type type) {
        if (type.equals(BigintType.BIGINT)) {
            return 19;
        }
        return null;
    }
}

