/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.connector.informationSchema.InformationSchemaColumnHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaSplit;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.util.Types;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class InformationSchemaSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;

    @Inject
    public InformationSchemaSplitManager(NodeManager nodeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public ConnectorPartitionResult getPartitions(ConnectorSession session, ConnectorTableHandle table, TupleDomain<ColumnHandle> tupleDomain) {
        Objects.requireNonNull(tupleDomain, "tupleDomain is null");
        InformationSchemaTableHandle informationSchemaTableHandle = Types.checkType(table, InformationSchemaTableHandle.class, "table");
        Map bindings = (Map)TupleDomain.extractFixedValues(tupleDomain).get();
        ImmutableList partitions = ImmutableList.of((Object)new InformationSchemaPartition(informationSchemaTableHandle, bindings));
        return new ConnectorPartitionResult((List)partitions, tupleDomain);
    }

    public ConnectorSplitSource getPartitionSplits(ConnectorSession session, ConnectorTableHandle table, List<ConnectorPartition> partitions) {
        Objects.requireNonNull(partitions, "partitions is null");
        if (partitions.isEmpty()) {
            return new FixedSplitSource(null, (Iterable)ImmutableList.of());
        }
        ConnectorPartition partition = (ConnectorPartition)Iterables.getOnlyElement(partitions);
        InformationSchemaPartition informationSchemaPartition = Types.checkType(partition, InformationSchemaPartition.class, "partition");
        ImmutableList localAddress = ImmutableList.of((Object)this.nodeManager.getCurrentNode().getHostAndPort());
        ImmutableMap.Builder filters = ImmutableMap.builder();
        for (Map.Entry<ColumnHandle, NullableValue> entry : informationSchemaPartition.getFilters().entrySet()) {
            InformationSchemaColumnHandle informationSchemaColumnHandle = (InformationSchemaColumnHandle)entry.getKey();
            filters.put((Object)informationSchemaColumnHandle.getColumnName(), (Object)entry.getValue());
        }
        InformationSchemaSplit split = new InformationSchemaSplit(informationSchemaPartition.getTable(), (Map<String, NullableValue>)filters.build(), (List<HostAddress>)localAddress);
        return new FixedSplitSource(null, (Iterable)ImmutableList.of((Object)split));
    }

    public static class InformationSchemaPartition
    implements ConnectorPartition {
        private final InformationSchemaTableHandle table;
        private final Map<ColumnHandle, NullableValue> filters;

        public InformationSchemaPartition(InformationSchemaTableHandle table, Map<ColumnHandle, NullableValue> filters) {
            this.table = Objects.requireNonNull(table, "table is null");
            this.filters = ImmutableMap.copyOf(Objects.requireNonNull(filters, "filters is null"));
        }

        public InformationSchemaTableHandle getTable() {
            return this.table;
        }

        public String getPartitionId() {
            return this.table.getSchemaTableName().toString();
        }

        public TupleDomain<ColumnHandle> getTupleDomain() {
            return TupleDomain.fromFixedValues(this.filters);
        }

        public Map<ColumnHandle, NullableValue> getFilters() {
            return this.filters;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("filters", this.filters).toString();
        }
    }
}

