/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.control;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.control.FlowControl;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public class TryCatch
implements FlowControl {
    private final String comment;
    private final ByteCodeNode tryNode;
    private final ByteCodeNode catchNode;
    private final String exceptionName;

    public TryCatch(String comment, ByteCodeNode tryNode, ByteCodeNode catchNode, ParameterizedType exceptionType) {
        this.comment = comment;
        this.tryNode = Objects.requireNonNull(tryNode, "tryNode is null");
        this.catchNode = Objects.requireNonNull(catchNode, "catchNode is null");
        this.exceptionName = exceptionType != null ? exceptionType.getClassName() : null;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public ByteCodeNode getTryNode() {
        return this.tryNode;
    }

    public ByteCodeNode getCatchNode() {
        return this.catchNode;
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        LabelNode tryStart = new LabelNode("tryStart");
        LabelNode tryEnd = new LabelNode("tryEnd");
        LabelNode handler = new LabelNode("handler");
        LabelNode done = new LabelNode("done");
        ByteCodeBlock block = new ByteCodeBlock();
        block.visitLabel(tryStart).append(this.tryNode).visitLabel(tryEnd).gotoLabel(done);
        block.visitLabel(handler).append(this.catchNode);
        block.visitLabel(done);
        block.accept(visitor, generationContext);
        visitor.visitTryCatchBlock(tryStart.getLabel(), tryEnd.getLabel(), handler.getLabel(), this.exceptionName);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.tryNode, (Object)this.catchNode);
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitTryCatch(parent, this);
    }
}

