/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.Comment;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.debug.LineNumberNode;
import com.facebook.presto.byteCode.instruction.Constant;
import com.facebook.presto.byteCode.instruction.FieldInstruction;
import com.facebook.presto.byteCode.instruction.InvokeInstruction;
import com.facebook.presto.byteCode.instruction.JumpInstruction;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.byteCode.instruction.TypeInstruction;
import com.facebook.presto.byteCode.instruction.VariableInstruction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.objectweb.asm.MethodVisitor;

@NotThreadSafe
public class ByteCodeBlock
implements ByteCodeNode {
    private final List<ByteCodeNode> nodes = new ArrayList<ByteCodeNode>();
    private String description;
    private int currentLineNumber = -1;

    public String getDescription() {
        return this.description;
    }

    public ByteCodeBlock setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.copyOf(this.nodes);
    }

    public ByteCodeBlock append(ByteCodeNode node) {
        this.nodes.add(node);
        return this;
    }

    public ByteCodeBlock comment(String comment) {
        this.nodes.add(new Comment(comment));
        return this;
    }

    public ByteCodeBlock comment(String comment, Object ... args) {
        this.nodes.add(new Comment(String.format(comment, args)));
        return this;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public ByteCodeBlock visitLabel(LabelNode label) {
        this.nodes.add(label);
        return this;
    }

    public ByteCodeBlock gotoLabel(LabelNode label) {
        this.nodes.add(JumpInstruction.jump(label));
        return this;
    }

    public ByteCodeBlock ifFalseGoto(LabelNode label) {
        return this.ifZeroGoto(label);
    }

    public ByteCodeBlock ifTrueGoto(LabelNode label) {
        return this.ifNotZeroGoto(label);
    }

    public ByteCodeBlock ifZeroGoto(LabelNode label) {
        this.nodes.add(JumpInstruction.jumpIfEqualZero(label));
        return this;
    }

    public ByteCodeBlock ifNotZeroGoto(LabelNode label) {
        this.nodes.add(JumpInstruction.jumpIfNotEqualZero(label));
        return this;
    }

    public ByteCodeBlock ifNullGoto(LabelNode label) {
        this.nodes.add(JumpInstruction.jumpIfNull(label));
        return this;
    }

    public ByteCodeBlock ifNotNullGoto(LabelNode label) {
        this.nodes.add(JumpInstruction.jumpIfNotNull(label));
        return this;
    }

    public ByteCodeBlock intAdd() {
        this.nodes.add(OpCode.IADD);
        return this;
    }

    public ByteCodeBlock longAdd() {
        this.nodes.add(OpCode.LADD);
        return this;
    }

    public ByteCodeBlock longCompare() {
        this.nodes.add(OpCode.LCMP);
        return this;
    }

    public ByteCodeBlock doubleCompareNanLess() {
        this.nodes.add(OpCode.DCMPL);
        return this;
    }

    public ByteCodeBlock doubleCompareNanGreater() {
        this.nodes.add(OpCode.DCMPG);
        return this;
    }

    public ByteCodeBlock intLeftShift() {
        this.nodes.add(OpCode.ISHL);
        return this;
    }

    public ByteCodeBlock intRightShift() {
        this.nodes.add(OpCode.ISHR);
        return this;
    }

    public ByteCodeBlock longLeftShift() {
        this.nodes.add(OpCode.LSHL);
        return this;
    }

    public ByteCodeBlock longRightShift() {
        this.nodes.add(OpCode.LSHR);
        return this;
    }

    public ByteCodeBlock unsignedIntRightShift() {
        this.nodes.add(OpCode.IUSHR);
        return this;
    }

    public ByteCodeBlock unsignedLongRightShift() {
        this.nodes.add(OpCode.LUSHR);
        return this;
    }

    public ByteCodeBlock intBitAnd() {
        this.nodes.add(OpCode.IAND);
        return this;
    }

    public ByteCodeBlock intBitOr() {
        this.nodes.add(OpCode.IOR);
        return this;
    }

    public ByteCodeBlock intBitXor() {
        this.nodes.add(OpCode.IXOR);
        return this;
    }

    public ByteCodeBlock longBitAnd() {
        this.nodes.add(OpCode.LAND);
        return this;
    }

    public ByteCodeBlock longBitOr() {
        this.nodes.add(OpCode.LOR);
        return this;
    }

    public ByteCodeBlock longBitXor() {
        this.nodes.add(OpCode.LXOR);
        return this;
    }

    public ByteCodeBlock intNegate() {
        this.nodes.add(OpCode.INEG);
        return this;
    }

    public ByteCodeBlock intToLong() {
        this.nodes.add(OpCode.I2L);
        return this;
    }

    public ByteCodeBlock longNegate() {
        this.nodes.add(OpCode.LNEG);
        return this;
    }

    public ByteCodeBlock longToInt() {
        this.nodes.add(OpCode.L2I);
        return this;
    }

    public ByteCodeBlock isInstanceOf(Class<?> type) {
        this.nodes.add(TypeInstruction.instanceOf(type));
        return this;
    }

    public ByteCodeBlock isInstanceOf(ParameterizedType type) {
        this.nodes.add(TypeInstruction.instanceOf(type));
        return this;
    }

    public ByteCodeBlock checkCast(Class<?> type) {
        this.nodes.add(TypeInstruction.cast(type));
        return this;
    }

    public ByteCodeBlock checkCast(ParameterizedType type) {
        this.nodes.add(TypeInstruction.cast(type));
        return this;
    }

    public ByteCodeBlock invokeStatic(Method method) {
        this.nodes.add(InvokeInstruction.invokeStatic(method));
        return this;
    }

    public ByteCodeBlock invokeStatic(MethodDefinition method) {
        this.nodes.add(InvokeInstruction.invokeStatic(method));
        return this;
    }

    public ByteCodeBlock invokeStatic(Class<?> type, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeStatic(type, name, returnType, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeStatic(Class<?> type, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeStatic(type, name, returnType, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeStatic(ParameterizedType type, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeStatic(type, name, returnType, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeStatic(ParameterizedType type, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeStatic(type, name, returnType, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeVirtual(Method method) {
        this.nodes.add(InvokeInstruction.invokeVirtual(method));
        return this;
    }

    public ByteCodeBlock invokeVirtual(MethodDefinition method) {
        this.nodes.add(InvokeInstruction.invokeVirtual(method));
        return this;
    }

    public ByteCodeBlock invokeVirtual(Class<?> type, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeVirtual(type, name, returnType, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeVirtual(Class<?> type, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeVirtual(type, name, returnType, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeVirtual(ParameterizedType type, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeVirtual(type, name, returnType, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeVirtual(ParameterizedType type, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeVirtual(type, name, returnType, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeInterface(Method method) {
        this.nodes.add(InvokeInstruction.invokeInterface(method));
        return this;
    }

    public ByteCodeBlock invokeInterface(MethodDefinition method) {
        this.nodes.add(InvokeInstruction.invokeInterface(method));
        return this;
    }

    public ByteCodeBlock invokeInterface(Class<?> type, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeInterface(type, name, returnType, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeInterface(Class<?> type, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeInterface(type, name, returnType, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeInterface(ParameterizedType type, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeInterface(type, name, returnType, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeInterface(ParameterizedType type, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeInterface(type, name, returnType, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeConstructor(Constructor<?> constructor) {
        this.nodes.add(InvokeInstruction.invokeConstructor(constructor));
        return this;
    }

    public ByteCodeBlock invokeConstructor(Class<?> type, Class<?> ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeConstructor(type, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeConstructor(Class<?> type, Iterable<Class<?>> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeConstructor(type, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeConstructor(ParameterizedType type, ParameterizedType ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeConstructor(type, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeConstructor(ParameterizedType type, Iterable<ParameterizedType> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeConstructor(type, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeSpecial(Method method) {
        this.nodes.add(InvokeInstruction.invokeSpecial(method));
        return this;
    }

    public ByteCodeBlock invokeSpecial(MethodDefinition method) {
        this.nodes.add(InvokeInstruction.invokeSpecial(method));
        return this;
    }

    public ByteCodeBlock invokeSpecial(Class<?> type, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeSpecial(type, name, returnType, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeSpecial(Class<?> type, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeSpecial(type, name, returnType, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeSpecial(ParameterizedType type, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeSpecial(type, name, returnType, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeSpecial(ParameterizedType type, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeSpecial(type, name, returnType, parameterTypes));
        return this;
    }

    public ByteCodeBlock invokeDynamic(String name, MethodType methodType, Method bootstrapMethod, Object ... defaultBootstrapArguments) {
        this.nodes.add(InvokeInstruction.invokeDynamic(name, methodType, bootstrapMethod, defaultBootstrapArguments));
        return this;
    }

    public ByteCodeNode invokeDynamic(String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, Method bootstrapMethod, List<Object> bootstrapArgs) {
        this.nodes.add(InvokeInstruction.invokeDynamic(name, returnType, parameterTypes, bootstrapMethod, bootstrapArgs));
        return this;
    }

    public ByteCodeBlock ret(Class<?> type) {
        if (type == Long.TYPE) {
            this.retLong();
        } else if (type == Boolean.TYPE) {
            this.retBoolean();
        } else if (type == Integer.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE) {
            this.retInt();
        } else if (type == Float.TYPE) {
            this.retFloat();
        } else if (type == Double.TYPE) {
            this.retDouble();
        } else if (type == Void.TYPE) {
            this.ret();
        } else if (!type.isPrimitive()) {
            this.retObject();
        } else {
            throw new IllegalArgumentException("Unsupported type: " + type.getName());
        }
        return this;
    }

    public ByteCodeBlock ret() {
        this.nodes.add(OpCode.RETURN);
        return this;
    }

    public ByteCodeBlock retObject() {
        this.nodes.add(OpCode.ARETURN);
        return this;
    }

    public ByteCodeBlock retFloat() {
        this.nodes.add(OpCode.FRETURN);
        return this;
    }

    public ByteCodeBlock retDouble() {
        this.nodes.add(OpCode.DRETURN);
        return this;
    }

    public ByteCodeBlock retBoolean() {
        this.nodes.add(OpCode.IRETURN);
        return this;
    }

    public ByteCodeBlock retLong() {
        this.nodes.add(OpCode.LRETURN);
        return this;
    }

    public ByteCodeBlock retInt() {
        this.nodes.add(OpCode.IRETURN);
        return this;
    }

    public ByteCodeBlock throwObject() {
        this.nodes.add(OpCode.ATHROW);
        return this;
    }

    public ByteCodeBlock newObject(Class<?> type) {
        this.nodes.add(TypeInstruction.newObject(type));
        return this;
    }

    public ByteCodeBlock newObject(ParameterizedType type) {
        this.nodes.add(TypeInstruction.newObject(type));
        return this;
    }

    public ByteCodeBlock newArray(Class<?> type) {
        this.nodes.add(TypeInstruction.newObjectArray(type));
        return this;
    }

    public ByteCodeBlock dup() {
        this.nodes.add(OpCode.DUP);
        return this;
    }

    public ByteCodeBlock dup(Class<?> type) {
        if (type == Long.TYPE || type == Double.TYPE) {
            this.nodes.add(OpCode.DUP2);
        } else {
            this.nodes.add(OpCode.DUP);
        }
        return this;
    }

    public ByteCodeBlock pop() {
        this.nodes.add(OpCode.POP);
        return this;
    }

    public ByteCodeBlock pop(Class<?> type) {
        if (type == Long.TYPE || type == Double.TYPE) {
            this.nodes.add(OpCode.POP2);
        } else if (type != Void.TYPE) {
            this.nodes.add(OpCode.POP);
        }
        return this;
    }

    public ByteCodeBlock pop(ParameterizedType type) {
        Class<?> primitiveType = type.getPrimitiveType();
        if (primitiveType == Long.TYPE || primitiveType == Double.TYPE) {
            this.nodes.add(OpCode.POP2);
        } else if (primitiveType != Void.TYPE) {
            this.nodes.add(OpCode.POP);
        }
        return this;
    }

    public ByteCodeBlock swap() {
        this.nodes.add(OpCode.SWAP);
        return this;
    }

    public ByteCodeBlock getField(Field field) {
        return this.getField(field.getDeclaringClass(), field.getName(), field.getType());
    }

    public ByteCodeBlock getField(FieldDefinition field) {
        this.getField(field.getDeclaringClass().getType(), field.getName(), field.getType());
        return this;
    }

    public ByteCodeBlock getField(Class<?> target, String fieldName, Class<?> fieldType) {
        this.getField(ParameterizedType.type(target), fieldName, ParameterizedType.type(fieldType));
        return this;
    }

    public ByteCodeBlock getField(ParameterizedType target, String fieldName, ParameterizedType fieldType) {
        this.nodes.add(FieldInstruction.getFieldInstruction(target, fieldName, fieldType));
        return this;
    }

    public ByteCodeBlock putField(Field field) {
        return this.putField(field.getDeclaringClass(), field.getName(), field.getType());
    }

    public ByteCodeBlock putField(Class<?> target, String fieldName, Class<?> fieldType) {
        this.putField(ParameterizedType.type(target), fieldName, ParameterizedType.type(fieldType));
        return this;
    }

    public ByteCodeBlock putField(FieldDefinition field) {
        Preconditions.checkArgument((!field.getAccess().contains((Object)Access.STATIC) ? 1 : 0) != 0, (String)"Field is static: %s", (Object[])new Object[]{field});
        this.putField(field.getDeclaringClass().getType(), field.getName(), field.getType());
        return this;
    }

    public ByteCodeBlock putField(ParameterizedType target, String fieldName, ParameterizedType fieldType) {
        this.nodes.add(FieldInstruction.putFieldInstruction(target, fieldName, fieldType));
        return this;
    }

    public ByteCodeBlock getStaticField(FieldDefinition field) {
        this.getStaticField(field.getDeclaringClass().getType(), field.getName(), field.getType());
        return this;
    }

    public ByteCodeBlock getStaticField(Field field) {
        Preconditions.checkArgument((boolean)Modifier.isStatic(field.getModifiers()), (String)"Field is not static: %s", (Object[])new Object[]{field});
        this.getStaticField(ParameterizedType.type(field.getDeclaringClass()), field.getName(), ParameterizedType.type(field.getType()));
        return this;
    }

    public ByteCodeBlock getStaticField(Class<?> target, String fieldName, Class<?> fieldType) {
        this.nodes.add(FieldInstruction.getStaticInstruction(target, fieldName, fieldType));
        return this;
    }

    public ByteCodeBlock getStaticField(ParameterizedType target, String fieldName, ParameterizedType fieldType) {
        this.nodes.add(FieldInstruction.getStaticInstruction(target, fieldName, fieldType));
        return this;
    }

    public ByteCodeBlock getStaticField(ParameterizedType target, FieldDefinition field) {
        this.nodes.add(FieldInstruction.getStaticInstruction(target, field.getName(), field.getType()));
        return this;
    }

    public ByteCodeBlock putStaticField(FieldDefinition field) {
        this.putStaticField(field.getDeclaringClass().getType(), field.getName(), field.getType());
        return this;
    }

    public ByteCodeBlock putStaticField(ParameterizedType target, FieldDefinition field) {
        Preconditions.checkArgument((boolean)field.getAccess().contains((Object)Access.STATIC), (String)"Field is not static: %s", (Object[])new Object[]{field});
        this.putStaticField(target, field.getName(), field.getType());
        return this;
    }

    public ByteCodeBlock putStaticField(ParameterizedType target, String fieldName, ParameterizedType fieldType) {
        this.nodes.add(FieldInstruction.putStaticInstruction(target, fieldName, fieldType));
        return this;
    }

    public ByteCodeBlock pushNull() {
        this.nodes.add(OpCode.ACONST_NULL);
        return this;
    }

    public ByteCodeBlock push(Class<?> type) {
        this.nodes.add(Constant.loadClass(type));
        return this;
    }

    public ByteCodeBlock push(ParameterizedType type) {
        this.nodes.add(Constant.loadClass(type));
        return this;
    }

    public ByteCodeBlock push(String value) {
        this.nodes.add(Constant.loadString(value));
        return this;
    }

    public ByteCodeBlock push(Number value) {
        this.nodes.add(Constant.loadNumber(value));
        return this;
    }

    public ByteCodeBlock push(int value) {
        this.nodes.add(Constant.loadInt(value));
        return this;
    }

    public ByteCodeBlock push(boolean value) {
        this.nodes.add(Constant.loadBoolean(value));
        return this;
    }

    public ByteCodeBlock pushJavaDefault(Class<?> type) {
        if (type == Void.TYPE) {
            return this;
        }
        if (type == Boolean.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE || type == Integer.TYPE) {
            return this.push(0);
        }
        if (type == Long.TYPE) {
            return this.push(0L);
        }
        if (type == Float.TYPE) {
            return this.push(Float.valueOf(0.0f));
        }
        if (type == Double.TYPE) {
            return this.push(0.0);
        }
        return this.pushNull();
    }

    public ByteCodeBlock initializeVariable(Variable variable) {
        ParameterizedType type = variable.getType();
        if (type.getType().length() == 1) {
            switch (type.getType().charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    this.nodes.add(Constant.loadInt(0));
                    break;
                }
                case 'F': {
                    this.nodes.add(Constant.loadFloat(0.0f));
                    break;
                }
                case 'D': {
                    this.nodes.add(Constant.loadDouble(0.0));
                    break;
                }
                case 'J': {
                    this.nodes.add(Constant.loadLong(0L));
                    break;
                }
                default: {
                    Preconditions.checkArgument((boolean)false, (String)"Unknown type '%s'", (Object[])new Object[]{variable.getType()});
                    break;
                }
            }
        } else {
            this.nodes.add(Constant.loadNull());
        }
        this.nodes.add(VariableInstruction.storeVariable(variable));
        return this;
    }

    public ByteCodeBlock getVariable(Variable variable) {
        this.nodes.add(VariableInstruction.loadVariable(variable));
        return this;
    }

    public ByteCodeBlock putVariable(Variable variable) {
        this.nodes.add(VariableInstruction.storeVariable(variable));
        return this;
    }

    public ByteCodeBlock putVariable(Variable variable, Class<?> type) {
        this.nodes.add(Constant.loadClass(type));
        this.putVariable(variable);
        return this;
    }

    public ByteCodeBlock putVariable(Variable variable, ParameterizedType type) {
        this.nodes.add(Constant.loadClass(type));
        this.putVariable(variable);
        return this;
    }

    public ByteCodeBlock putVariable(Variable variable, String value) {
        this.nodes.add(Constant.loadString(value));
        this.putVariable(variable);
        return this;
    }

    public ByteCodeBlock putVariable(Variable variable, Number value) {
        this.nodes.add(Constant.loadNumber(value));
        this.putVariable(variable);
        return this;
    }

    public ByteCodeBlock putVariable(Variable variable, int value) {
        this.nodes.add(Constant.loadInt(value));
        this.putVariable(variable);
        return this;
    }

    public ByteCodeBlock putVariable(Variable variable, boolean value) {
        this.nodes.add(Constant.loadBoolean(value));
        this.putVariable(variable);
        return this;
    }

    public ByteCodeBlock incrementVariable(Variable variable, byte increment) {
        String type = variable.getType().getClassName();
        Preconditions.checkArgument((boolean)ImmutableList.of((Object)"byte", (Object)"short", (Object)"int").contains((Object)type), (String)"variable must be an byte, short or int, but is %s", (Object[])new Object[]{type});
        this.nodes.add(VariableInstruction.incrementVariable(variable, increment));
        return this;
    }

    public ByteCodeBlock getObjectArrayElement() {
        this.nodes.add(OpCode.AALOAD);
        return this;
    }

    public ByteCodeBlock putObjectArrayElement() {
        this.nodes.add(OpCode.AASTORE);
        return this;
    }

    public ByteCodeBlock visitLineNumber(int currentLineNumber) {
        Preconditions.checkArgument((currentLineNumber >= 0 ? 1 : 0) != 0, (Object)"currentLineNumber must be positive");
        if (this.currentLineNumber != currentLineNumber) {
            this.nodes.add(new LineNumberNode(currentLineNumber));
            this.currentLineNumber = currentLineNumber;
        }
        return this;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        for (ByteCodeNode node : this.nodes) {
            node.accept(visitor, generationContext);
        }
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitBlock(parent, this);
    }
}

