/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.Request;
import io.airlift.node.NodeInfo;
import java.util.Objects;
import javax.inject.Inject;

public class NodeIdUserAgentRequestFilter
implements HttpRequestFilter {
    private final String nodeId;

    @Inject
    public NodeIdUserAgentRequestFilter(NodeInfo nodeInfo) {
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        this.nodeId = Objects.requireNonNull(nodeInfo.getNodeId(), "nodeId is null");
    }

    public Request filterRequest(Request request) {
        Objects.requireNonNull(request, "request is null");
        return Request.Builder.fromRequest((Request)request).addHeader("User-Agent", this.nodeId).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.nodeId.equals(((NodeIdUserAgentRequestFilter)obj).nodeId);
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }
}

