/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.client.ErrorLocation;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Failure;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class Failures {
    private static final String NODE_CRASHED_ERROR = "The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.";
    public static final String WORKER_NODE_ERROR = "Encountered too many errors talking to a worker node. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.";
    public static final String WORKER_RESTARTED_ERROR = "A worker node running your query has restarted. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.";

    private Failures() {
    }

    public static ExecutionFailureInfo toFailure(Throwable failure) {
        if (failure == null) {
            return null;
        }
        String type = failure instanceof Failure ? ((Failure)failure).getType() : failure.getClass().getCanonicalName();
        return new ExecutionFailureInfo(type, failure.getMessage(), Failures.toFailure(failure.getCause()), Failures.toFailures(Arrays.asList(failure.getSuppressed())), Lists.transform(Arrays.asList(failure.getStackTrace()), (Function)Functions.toStringFunction()), Failures.getErrorLocation(failure), Failures.toErrorCode(failure));
    }

    public static void checkCondition(boolean condition, ErrorCodeSupplier errorCode, String formatString, Object ... args) {
        if (!condition) {
            throw new PrestoException(errorCode, String.format(formatString, args));
        }
    }

    public static List<ExecutionFailureInfo> toFailures(Collection<? extends Throwable> failures) {
        return (List)failures.stream().map(Failures::toFailure).collect(ImmutableCollectors.toImmutableList());
    }

    @Nullable
    private static ErrorLocation getErrorLocation(Throwable throwable) {
        if (throwable instanceof ParsingException) {
            ParsingException e = (ParsingException)throwable;
            return new ErrorLocation(e.getLineNumber(), e.getColumnNumber());
        }
        return null;
    }

    @Nullable
    private static ErrorCode toErrorCode(@Nullable Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof PrestoException) {
            return ((PrestoException)throwable).getErrorCode();
        }
        if (throwable instanceof Failure && ((Failure)throwable).getErrorCode() != null) {
            return ((Failure)throwable).getErrorCode();
        }
        if (throwable instanceof ParsingException || throwable instanceof SemanticException) {
            return StandardErrorCode.SYNTAX_ERROR.toErrorCode();
        }
        if (throwable.getCause() != null) {
            return Failures.toErrorCode(throwable.getCause());
        }
        return StandardErrorCode.INTERNAL_ERROR.toErrorCode();
    }
}

