/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TestingAccessControlManager
extends AccessControlManager {
    private final Set<TestingPrivilege> denyPrivileges = new HashSet<TestingPrivilege>();

    public TestingAccessControlManager() {
        this.setSystemAccessControl("allow-all", (Map<String, String>)ImmutableMap.of());
    }

    public static TestingPrivilege privilege(String entityName, TestingPrivilegeType type) {
        return new TestingPrivilege(Optional.empty(), entityName, type);
    }

    public static TestingPrivilege privilege(String userName, String entityName, TestingPrivilegeType type) {
        return new TestingPrivilege(Optional.of(userName), entityName, type);
    }

    public void deny(TestingPrivilege ... deniedPrivileges) {
        Collections.addAll(this.denyPrivileges, deniedPrivileges);
    }

    public void reset() {
        this.denyPrivileges.clear();
    }

    @Override
    public void checkCanSetUser(Principal principal, String userName) {
        if (this.shouldDenyPrivilege(userName, userName, TestingPrivilegeType.SET_USER)) {
            AccessDeniedException.denySetUser((Principal)principal, (String)userName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetUser(principal, userName);
        }
    }

    @Override
    public void checkCanCreateTable(Identity identity, QualifiedTableName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getTableName(), TestingPrivilegeType.CREATE_TABLE)) {
            AccessDeniedException.denyCreateTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateTable(identity, tableName);
        }
    }

    @Override
    public void checkCanDropTable(Identity identity, QualifiedTableName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getTableName(), TestingPrivilegeType.DROP_TABLE)) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDropTable(identity, tableName);
        }
    }

    @Override
    public void checkCanRenameTable(Identity identity, QualifiedTableName tableName, QualifiedTableName newTableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getTableName(), TestingPrivilegeType.RENAME_TABLE)) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanRenameTable(identity, tableName, newTableName);
        }
    }

    @Override
    public void checkCanAddColumns(Identity identity, QualifiedTableName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getTableName(), TestingPrivilegeType.ADD_COLUMN)) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
        super.checkCanAddColumns(identity, tableName);
    }

    @Override
    public void checkCanRenameColumn(Identity identity, QualifiedTableName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getTableName(), TestingPrivilegeType.RENAME_COLUMN)) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
        super.checkCanRenameColumn(identity, tableName);
    }

    @Override
    public void checkCanSelectFromTable(Identity identity, QualifiedTableName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getTableName(), TestingPrivilegeType.SELECT_TABLE)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSelectFromTable(identity, tableName);
        }
    }

    @Override
    public void checkCanInsertIntoTable(Identity identity, QualifiedTableName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getTableName(), TestingPrivilegeType.INSERT_TABLE)) {
            AccessDeniedException.denyInsertTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanInsertIntoTable(identity, tableName);
        }
    }

    @Override
    public void checkCanDeleteFromTable(Identity identity, QualifiedTableName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getTableName(), TestingPrivilegeType.DELETE_TABLE)) {
            AccessDeniedException.denyDeleteTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDeleteFromTable(identity, tableName);
        }
    }

    @Override
    public void checkCanCreateView(Identity identity, QualifiedTableName viewName) {
        if (this.shouldDenyPrivilege(identity.getUser(), viewName.getTableName(), TestingPrivilegeType.CREATE_VIEW)) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateView(identity, viewName);
        }
    }

    @Override
    public void checkCanDropView(Identity identity, QualifiedTableName viewName) {
        if (this.shouldDenyPrivilege(identity.getUser(), viewName.getTableName(), TestingPrivilegeType.DROP_VIEW)) {
            AccessDeniedException.denyDropView((String)viewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDropView(identity, viewName);
        }
    }

    @Override
    public void checkCanSelectFromView(Identity identity, QualifiedTableName viewName) {
        if (this.shouldDenyPrivilege(identity.getUser(), viewName.getTableName(), TestingPrivilegeType.SELECT_VIEW)) {
            AccessDeniedException.denySelectView((String)viewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSelectFromView(identity, viewName);
        }
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        if (this.shouldDenyPrivilege(identity.getUser(), propertyName, TestingPrivilegeType.SET_SESSION)) {
            AccessDeniedException.denySetSystemSessionProperty((String)propertyName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetSystemSessionProperty(identity, propertyName);
        }
    }

    @Override
    public void checkCanCreateViewWithSelectFromTable(Identity identity, QualifiedTableName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getTableName(), TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_TABLE)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateViewWithSelectFromTable(identity, tableName);
        }
    }

    @Override
    public void checkCanCreateViewWithSelectFromView(Identity identity, QualifiedTableName viewName) {
        if (this.shouldDenyPrivilege(identity.getUser(), viewName.getTableName(), TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_VIEW)) {
            AccessDeniedException.denySelectView((String)viewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateViewWithSelectFromView(identity, viewName);
        }
    }

    @Override
    public void checkCanSetCatalogSessionProperty(Identity identity, String catalogName, String propertyName) {
        if (this.shouldDenyPrivilege(identity.getUser(), catalogName + "." + propertyName, TestingPrivilegeType.SET_SESSION)) {
            AccessDeniedException.denySetCatalogSessionProperty((String)catalogName, (String)propertyName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetCatalogSessionProperty(identity, catalogName, propertyName);
        }
    }

    private boolean shouldDenyPrivilege(String userName, String entityName, TestingPrivilegeType type) {
        TestingPrivilege testPrivilege = TestingAccessControlManager.privilege(userName, entityName, type);
        for (TestingPrivilege denyPrivilege : this.denyPrivileges) {
            if (!denyPrivilege.matches(testPrivilege)) continue;
            return true;
        }
        return false;
    }

    public static class TestingPrivilege {
        private final Optional<String> userName;
        private final String entityName;
        private final TestingPrivilegeType type;

        private TestingPrivilege(Optional<String> userName, String entityName, TestingPrivilegeType type) {
            this.userName = Objects.requireNonNull(userName, "userName is null");
            this.entityName = Objects.requireNonNull(entityName, "entityName is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public boolean matches(TestingPrivilege testPrivilege) {
            return this.userName.map(name -> testingPrivilege.userName.get().equals(name)).orElse(true) != false && this.entityName.equals(testPrivilege.entityName) && this.type == testPrivilege.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestingPrivilege that = (TestingPrivilege)o;
            return Objects.equals(this.entityName, that.entityName) && Objects.equals((Object)this.type, (Object)that.type);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.entityName, this.type});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("userName", this.userName).add("entityName", (Object)this.entityName).add("type", (Object)this.type).toString();
        }
    }

    public static enum TestingPrivilegeType {
        SET_USER,
        CREATE_TABLE,
        DROP_TABLE,
        RENAME_TABLE,
        SELECT_TABLE,
        INSERT_TABLE,
        DELETE_TABLE,
        ADD_COLUMN,
        RENAME_COLUMN,
        CREATE_VIEW,
        DROP_VIEW,
        SELECT_VIEW,
        CREATE_VIEW_WITH_SELECT_TABLE,
        CREATE_VIEW_WITH_SELECT_VIEW,
        SET_SESSION;

    }
}

