/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.FunctionType;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public final class Signatures {
    public static final String IF = "IF";
    public static final String NULL_IF = "NULL_IF";
    public static final String SWITCH = "SWITCH";
    public static final String CAST = FunctionRegistry.mangleOperatorName("CAST");
    public static final String TRY_CAST = "TRY_CAST";
    public static final String IS_NULL = "IS_NULL";
    public static final String COALESCE = "COALESCE";
    public static final String IN = "IN";

    private Signatures() {
    }

    public static Signature notSignature() {
        return new Signature("not", FunctionType.SCALAR, "boolean", (List<String>)ImmutableList.of((Object)"boolean"));
    }

    public static Signature betweenSignature(Type valueType, Type minType, Type maxType) {
        return Signature.internalOperator("BETWEEN", TypeSignature.parseTypeSignature((String)"boolean"), valueType.getTypeSignature(), minType.getTypeSignature(), maxType.getTypeSignature());
    }

    public static Signature likeSignature() {
        return Signature.internalScalarFunction("LIKE", "boolean", "varchar", "LikePattern");
    }

    public static Signature likePatternSignature() {
        return Signature.internalScalarFunction("LIKE_PATTERN", "LikePattern", "varchar", "varchar");
    }

    public static Signature castSignature(Type returnType, Type valueType) {
        return Signature.internalScalarFunction(CAST, returnType.getTypeSignature(), valueType.getTypeSignature());
    }

    public static Signature tryCastSignature(Type returnType, Type valueType) {
        return Signature.internalScalarFunction(TRY_CAST, returnType.getTypeSignature(), valueType.getTypeSignature());
    }

    public static Signature logicalExpressionSignature(LogicalBinaryExpression.Type expressionType) {
        return Signature.internalScalarFunction(expressionType.name(), "boolean", "boolean", "boolean");
    }

    public static Signature arithmeticNegationSignature(Type returnType, Type valueType) {
        return Signature.internalOperator("NEGATION", returnType.getTypeSignature(), valueType.getTypeSignature());
    }

    public static Signature arithmeticExpressionSignature(ArithmeticBinaryExpression.Type expressionType, Type returnType, Type leftType, Type rightType) {
        return Signature.internalOperator(expressionType.name(), returnType.getTypeSignature(), leftType.getTypeSignature(), rightType.getTypeSignature());
    }

    public static Signature subscriptSignature(Type returnType, Type leftType, Type rightType) {
        return Signature.internalOperator(OperatorType.SUBSCRIPT.name(), returnType.getTypeSignature(), leftType.getTypeSignature(), rightType.getTypeSignature());
    }

    public static Signature arrayConstructorSignature(Type returnType, List<? extends Type> argumentTypes) {
        return Signature.internalScalarFunction("ARRAY_CONSTRUCTOR", returnType.getTypeSignature(), Lists.transform(argumentTypes, Type::getTypeSignature));
    }

    public static Signature arrayConstructorSignature(TypeSignature returnType, List<TypeSignature> argumentTypes) {
        return Signature.internalScalarFunction("ARRAY_CONSTRUCTOR", returnType, argumentTypes);
    }

    public static Signature comparisonExpressionSignature(ComparisonExpression.Type expressionType, Type leftType, Type rightType) {
        for (OperatorType operatorType : OperatorType.values()) {
            if (!operatorType.name().equals(expressionType.name())) continue;
            return Signature.internalOperator(expressionType.name(), TypeSignature.parseTypeSignature((String)"boolean"), leftType.getTypeSignature(), rightType.getTypeSignature());
        }
        return Signature.internalScalarFunction(expressionType.name(), TypeSignature.parseTypeSignature((String)"boolean"), leftType.getTypeSignature(), rightType.getTypeSignature());
    }

    public static Signature ifSignature(Type returnType) {
        return new Signature(IF, FunctionType.SCALAR, returnType.getTypeSignature(), new TypeSignature[0]);
    }

    public static Signature nullIfSignature(Type returnType, Type firstType, Type secondType) {
        return new Signature(NULL_IF, FunctionType.SCALAR, returnType.getTypeSignature(), firstType.getTypeSignature(), secondType.getTypeSignature());
    }

    public static Signature switchSignature(Type returnType) {
        return new Signature(SWITCH, FunctionType.SCALAR, returnType.getTypeSignature(), new TypeSignature[0]);
    }

    public static Signature whenSignature(Type returnType) {
        return new Signature("WHEN", FunctionType.SCALAR, returnType.getTypeSignature(), new TypeSignature[0]);
    }

    public static Signature inSignature() {
        return Signature.internalScalarFunction(IN, "boolean", new String[0]);
    }

    public static Signature isNullSignature(Type argumentType) {
        return Signature.internalScalarFunction(IS_NULL, TypeSignature.parseTypeSignature((String)"boolean"), argumentType.getTypeSignature());
    }

    public static Signature coalesceSignature(Type returnType, List<Type> argumentTypes) {
        return Signature.internalScalarFunction(COALESCE, returnType.getTypeSignature(), Lists.transform(argumentTypes, Type::getTypeSignature));
    }
}

