/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DeleteNode
extends PlanNode {
    private final PlanNode source;
    private final TableWriterNode.DeleteHandle target;
    private final Symbol rowId;
    private final List<Symbol> outputs;

    @JsonCreator
    public DeleteNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") TableWriterNode.DeleteHandle target, @JsonProperty(value="rowId") Symbol rowId, @JsonProperty(value="outputs") List<Symbol> outputs) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.rowId = Objects.requireNonNull(rowId, "rowId is null");
        this.outputs = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputs, "outputs is null"));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public TableWriterNode.DeleteHandle getTarget() {
        return this.target;
    }

    @JsonProperty
    public Symbol getRowId() {
        return this.rowId;
    }

    @Override
    @JsonProperty(value="outputs")
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitDelete(this, context);
    }
}

