/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.PlanSanityChecker;
import com.facebook.presto.sql.planner.QueryPlanner;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.TableCommitNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class LogicalPlanner {
    private final PlanNodeIdAllocator idAllocator;
    private final Session session;
    private final List<PlanOptimizer> planOptimizers;
    private final SymbolAllocator symbolAllocator = new SymbolAllocator();
    private final Metadata metadata;

    public LogicalPlanner(Session session, List<PlanOptimizer> planOptimizers, PlanNodeIdAllocator idAllocator, Metadata metadata) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(planOptimizers, "planOptimizers is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(metadata, "metadata is null");
        this.session = session;
        this.planOptimizers = planOptimizers;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
    }

    public Plan plan(Analysis analysis) {
        RelationPlan plan = analysis.getCreateTableDestination().isPresent() ? this.createTableCreationPlan(analysis) : (analysis.getInsertTarget().isPresent() ? this.createInsertPlan(analysis) : (analysis.getDelete().isPresent() ? this.createDeletePlan(analysis) : this.createRelationPlan(analysis)));
        PlanNode root = this.createOutputPlan(plan, analysis);
        PlanSanityChecker.validate(root);
        for (PlanOptimizer optimizer : this.planOptimizers) {
            root = optimizer.optimize(root, this.session, this.symbolAllocator.getTypes(), this.symbolAllocator, this.idAllocator);
            Objects.requireNonNull(root, String.format("%s returned a null plan", optimizer.getClass().getName()));
        }
        PlanSanityChecker.validate(root);
        return new Plan(root, this.symbolAllocator);
    }

    private RelationPlan createTableCreationPlan(Analysis analysis) {
        QualifiedTableName destination = analysis.getCreateTableDestination().get();
        RelationPlan plan = this.createRelationPlan(analysis);
        TableMetadata tableMetadata = this.createTableMetadata(destination, LogicalPlanner.getOutputTableColumns(plan), analysis.getCreateTableProperties(), plan.getSampleWeight().isPresent());
        if (plan.getSampleWeight().isPresent() && !this.metadata.canCreateSampledTables(this.session, destination.getCatalogName())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot write sampled data to a store that doesn't support sampling");
        }
        return this.createTableWriterPlan(analysis, plan, new TableWriterNode.CreateName(destination.getCatalogName(), tableMetadata), LogicalPlanner.getVisibleColumnNames(tableMetadata));
    }

    private RelationPlan createInsertPlan(Analysis analysis) {
        TableHandle target = analysis.getInsertTarget().get();
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, target);
        return this.createTableWriterPlan(analysis, this.createRelationPlan(analysis), new TableWriterNode.InsertReference(target), LogicalPlanner.getVisibleColumnNames(tableMetadata));
    }

    private RelationPlan createTableWriterPlan(Analysis analysis, RelationPlan plan, TableWriterNode.WriterTarget target, List<String> columnNames) {
        ImmutableList writerOutputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), (Object)this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY));
        PlanNode source = plan.getRoot();
        if (!analysis.isCreateTableAsSelectWithData()) {
            source = new LimitNode(this.idAllocator.getNextId(), source, 0L);
        }
        TableWriterNode writerNode = new TableWriterNode(this.idAllocator.getNextId(), source, target, plan.getOutputSymbols(), columnNames, (List<Symbol>)writerOutputs, plan.getSampleWeight());
        ImmutableList outputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT));
        TableCommitNode commitNode = new TableCommitNode(this.idAllocator.getNextId(), writerNode, target, (List<Symbol>)outputs);
        return new RelationPlan(commitNode, analysis.getOutputDescriptor(), (List<Symbol>)outputs, Optional.empty());
    }

    private RelationPlan createDeletePlan(Analysis analysis) {
        QueryPlanner planner = new QueryPlanner(analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session);
        DeleteNode deleteNode = planner.planDelete(analysis.getDelete().get());
        ImmutableList outputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT));
        TableCommitNode commitNode = new TableCommitNode(this.idAllocator.getNextId(), deleteNode, deleteNode.getTarget(), (List<Symbol>)outputs);
        return new RelationPlan(commitNode, analysis.getOutputDescriptor(), commitNode.getOutputSymbols(), Optional.empty());
    }

    private PlanNode createOutputPlan(RelationPlan plan, Analysis analysis) {
        ImmutableList.Builder outputs = ImmutableList.builder();
        ImmutableList.Builder names = ImmutableList.builder();
        int columnNumber = 0;
        TupleDescriptor outputDescriptor = analysis.getOutputDescriptor();
        for (Field field : outputDescriptor.getVisibleFields()) {
            String name = field.getName().orElse("_col" + columnNumber);
            names.add((Object)name);
            int fieldIndex = outputDescriptor.indexOf(field);
            Symbol symbol = plan.getSymbol(fieldIndex);
            outputs.add((Object)symbol);
            ++columnNumber;
        }
        return new OutputNode(this.idAllocator.getNextId(), plan.getRoot(), (List<String>)names.build(), (List<Symbol>)outputs.build());
    }

    private RelationPlan createRelationPlan(Analysis analysis) {
        return (RelationPlan)new RelationPlanner(analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)analysis.getQuery(), null);
    }

    private TableMetadata createTableMetadata(QualifiedTableName table, List<ColumnMetadata> columns, Map<String, Expression> propertyExpressions, boolean sampled) {
        String owner = this.session.getUser();
        Map<String, Object> properties = this.metadata.getTablePropertyManager().getTableProperties(table.getCatalogName(), propertyExpressions, this.session, this.metadata);
        ConnectorTableMetadata metadata = new ConnectorTableMetadata(table.asSchemaTableName(), columns, properties, owner, sampled);
        return new TableMetadata(table.getCatalogName(), metadata);
    }

    private static List<ColumnMetadata> getOutputTableColumns(RelationPlan plan) {
        ImmutableList.Builder columns = ImmutableList.builder();
        for (Field field : plan.getDescriptor().getVisibleFields()) {
            columns.add((Object)new ColumnMetadata(field.getName().get(), field.getType(), false));
        }
        return columns.build();
    }

    private static List<String> getVisibleColumnNames(TableMetadata tableMetadata) {
        return (List)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).map(ColumnMetadata::getName).collect(ImmutableCollectors.toImmutableList());
    }
}

