/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.Parameter;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.ForLoop;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BodyCompiler;
import com.facebook.presto.sql.gen.ByteCodeExpressionVisitor;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

public class PageProcessorCompiler
implements BodyCompiler<PageProcessor> {
    private final Metadata metadata;

    public PageProcessorCompiler(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void generateMethods(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter, List<RowExpression> projections) {
        this.generateProcessMethod(classDefinition, filter, projections);
        this.generateFilterMethod(classDefinition, callSiteBinder, filter);
        for (int i = 0; i < projections.size(); ++i) {
            this.generateProjectMethod(classDefinition, callSiteBinder, "project_" + i, projections.get(i));
        }
    }

    private void generateProcessMethod(ClassDefinition classDefinition, RowExpression filter, List<RowExpression> projections) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        Parameter page = Parameter.arg("page", Page.class);
        Parameter start = Parameter.arg("start", Integer.TYPE);
        Parameter end = Parameter.arg("end", Integer.TYPE);
        Parameter pageBuilder = Parameter.arg("pageBuilder", PageBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), "process", ParameterizedType.type(Integer.TYPE), session, page, start, end, pageBuilder);
        Scope scope = method.getScope();
        Variable thisVariable = method.getThis();
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        method.getBody().comment("int position = start;").getVariable(start).putVariable(position);
        List<Integer> allInputChannels = PageProcessorCompiler.getInputChannels(Iterables.concat(projections, (Iterable)ImmutableList.of((Object)filter)));
        for (int channel : allInputChannels) {
            Variable blockVariable = scope.declareVariable(Block.class, "block_" + channel);
            method.getBody().comment("Block %s = page.getBlock(%s);", blockVariable.getName(), channel).getVariable(page).push(channel).invokeVirtual(Page.class, "getBlock", Block.class, Integer.TYPE).putVariable(blockVariable);
        }
        LabelNode done = new LabelNode("done");
        ByteCodeBlock loopBody = new ByteCodeBlock();
        ForLoop loop = new ForLoop().initialize(OpCode.NOP).condition(new ByteCodeBlock().comment("position < end").getVariable(position).getVariable(end).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, Integer.TYPE, Integer.TYPE)).update(new ByteCodeBlock().comment("position++").incrementVariable(position, (byte)1)).body(loopBody);
        loopBody.comment("if (pageBuilder.isFull()) break;").getVariable(pageBuilder).invokeVirtual(PageBuilder.class, "isFull", Boolean.TYPE, new Class[0]).ifTrueGoto(done);
        IfStatement filterBlock = new IfStatement();
        filterBlock.condition().append(thisVariable).getVariable(session).append(PageProcessorCompiler.pushBlockVariables(scope, PageProcessorCompiler.getInputChannels(filter))).getVariable(position).invokeVirtual(classDefinition.getType(), "filter", ParameterizedType.type(Boolean.TYPE), (Iterable<ParameterizedType>)ImmutableList.builder().add((Object)ParameterizedType.type(ConnectorSession.class)).addAll(Collections.nCopies(PageProcessorCompiler.getInputChannels(filter).size(), ParameterizedType.type(Block.class))).add((Object)ParameterizedType.type(Integer.TYPE)).build());
        filterBlock.ifTrue().append(pageBuilder).invokeVirtual(PageBuilder.class, "declarePosition", Void.TYPE, new Class[0]);
        for (int projectionIndex = 0; projectionIndex < projections.size(); ++projectionIndex) {
            List<Integer> inputChannels = PageProcessorCompiler.getInputChannels(projections.get(projectionIndex));
            filterBlock.ifTrue().append(thisVariable).append(session).append(PageProcessorCompiler.pushBlockVariables(scope, inputChannels)).getVariable(position);
            filterBlock.ifTrue().comment("pageBuilder.getBlockBuilder(%d)", projectionIndex).append(pageBuilder).push(projectionIndex).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, Integer.TYPE);
            filterBlock.ifTrue().comment("project_%d(session, block_%s, position, blockBuilder)", projectionIndex, inputChannels).invokeVirtual(classDefinition.getType(), "project_" + projectionIndex, ParameterizedType.type(Void.TYPE), (Iterable<ParameterizedType>)ImmutableList.builder().add((Object)ParameterizedType.type(ConnectorSession.class)).addAll(Collections.nCopies(inputChannels.size(), ParameterizedType.type(Block.class))).add((Object)ParameterizedType.type(Integer.TYPE)).add((Object)ParameterizedType.type(BlockBuilder.class)).build());
        }
        loopBody.append(filterBlock);
        method.getBody().append(loop).visitLabel(done).comment("return position;").getVariable(position).retInt();
    }

    private void generateFilterMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        List<Parameter> blocks = PageProcessorCompiler.toBlockParameters(PageProcessorCompiler.getInputChannels(filter));
        Parameter position = Parameter.arg("position", Integer.TYPE);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), "filter", ParameterizedType.type(Boolean.TYPE), (Iterable<Parameter>)ImmutableList.builder().add((Object)session).addAll(blocks).add((Object)position).build());
        method.comment("Filter: %s", filter.toString());
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        ByteCodeExpressionVisitor visitor = new ByteCodeExpressionVisitor(callSiteBinder, this.fieldReferenceCompiler(callSiteBinder, position, wasNullVariable), this.metadata.getFunctionRegistry());
        ByteCodeNode body = filter.accept(visitor, scope);
        LabelNode end = new LabelNode("end");
        method.getBody().comment("boolean wasNull = false;").putVariable(wasNullVariable, false).append(body).getVariable(wasNullVariable).ifFalseGoto(end).pop(Boolean.TYPE).push(false).visitLabel(end).retBoolean();
    }

    private void generateProjectMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, String methodName, RowExpression projection) {
        Parameter session = Parameter.arg("session", ConnectorSession.class);
        List<Parameter> inputs = PageProcessorCompiler.toBlockParameters(PageProcessorCompiler.getInputChannels(projection));
        Parameter position = Parameter.arg("position", Integer.TYPE);
        Parameter output = Parameter.arg("output", BlockBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a(Access.PUBLIC), methodName, ParameterizedType.type(Void.TYPE), (Iterable<Parameter>)ImmutableList.builder().add((Object)session).addAll(inputs).add((Object)position).add((Object)output).build());
        method.comment("Projection: %s", projection.toString());
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        ByteCodeBlock body = method.getBody().comment("boolean wasNull = false;").putVariable(wasNullVariable, false);
        ByteCodeExpressionVisitor visitor = new ByteCodeExpressionVisitor(callSiteBinder, this.fieldReferenceCompiler(callSiteBinder, position, wasNullVariable), this.metadata.getFunctionRegistry());
        body.getVariable(output).comment("evaluate projection: " + projection.toString()).append(projection.accept(visitor, scope)).append(ByteCodeUtils.generateWrite(callSiteBinder, scope, wasNullVariable, projection.getType())).ret();
    }

    private static List<Integer> getInputChannels(Iterable<RowExpression> expressions) {
        TreeSet<Integer> channels = new TreeSet<Integer>();
        for (RowExpression expression : Expressions.subExpressions(expressions)) {
            if (!(expression instanceof InputReferenceExpression)) continue;
            channels.add(((InputReferenceExpression)expression).getField());
        }
        return ImmutableList.copyOf(channels);
    }

    private static List<Integer> getInputChannels(RowExpression expression) {
        return PageProcessorCompiler.getInputChannels((Iterable<RowExpression>)ImmutableList.of((Object)expression));
    }

    private static List<Parameter> toBlockParameters(List<Integer> inputChannels) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int channel : inputChannels) {
            parameters.add((Object)Parameter.arg("block_" + channel, Block.class));
        }
        return parameters.build();
    }

    private static ByteCodeNode pushBlockVariables(Scope scope, List<Integer> inputs) {
        ByteCodeBlock block = new ByteCodeBlock();
        for (int channel : inputs) {
            block.append(scope.getVariable("block_" + channel));
        }
        return block;
    }

    private RowExpressionVisitor<Scope, ByteCodeNode> fieldReferenceCompiler(final CallSiteBinder callSiteBinder, final Variable positionVariable, final Variable wasNullVariable) {
        return new RowExpressionVisitor<Scope, ByteCodeNode>(){

            @Override
            public ByteCodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
                int field = node.getField();
                Type type = node.getType();
                Variable block = scope.getVariable("block_" + field);
                Class<Object> javaType = type.getJavaType();
                if (!javaType.isPrimitive() && javaType != Slice.class) {
                    javaType = Object.class;
                }
                IfStatement ifStatement = new IfStatement();
                ifStatement.condition().setDescription(String.format("block_%d.get%s()", field, type)).append(block).getVariable(positionVariable).invokeInterface(Block.class, "isNull", Boolean.TYPE, Integer.TYPE);
                ifStatement.ifTrue().putVariable(wasNullVariable, true).pushJavaDefault(javaType);
                String methodName = "get" + Primitives.wrap(javaType).getSimpleName();
                ifStatement.ifFalse().append(ByteCodeUtils.loadConstant(callSiteBinder.bind(type, Type.class))).append(block).getVariable(positionVariable).invokeInterface(Type.class, methodName, javaType, Block.class, Integer.TYPE);
                return ifStatement;
            }

            @Override
            public ByteCodeNode visitCall(CallExpression call, Scope scope) {
                throw new UnsupportedOperationException("not yet implemented");
            }

            @Override
            public ByteCodeNode visitConstant(ConstantExpression literal, Scope scope) {
                throw new UnsupportedOperationException("not yet implemented");
            }
        };
    }
}

