/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.ByteCodeGenerator;
import com.facebook.presto.sql.gen.ByteCodeGeneratorContext;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class NullIfCodeGenerator
implements ByteCodeGenerator {
    @Override
    public ByteCodeNode generateExpression(Signature signature, ByteCodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        Scope scope = generatorContext.getScope();
        RowExpression first = arguments.get(0);
        RowExpression second = arguments.get(1);
        LabelNode notMatch = new LabelNode("notMatch");
        ByteCodeBlock block = new ByteCodeBlock().comment("check if first arg is null").append(generatorContext.generate(first)).append(ByteCodeUtils.ifWasNullPopAndGoto(scope, notMatch, Void.TYPE, new Class[0]));
        Type firstType = first.getType();
        Type secondType = second.getType();
        Type commonType = FunctionRegistry.getCommonSuperType(firstType, secondType).get();
        Signature operatorSignature = generatorContext.getRegistry().resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)firstType, (Object)secondType));
        ScalarFunctionImplementation equalsFunction = generatorContext.getRegistry().getScalarFunctionImplementation(operatorSignature);
        ByteCodeNode equalsCall = generatorContext.generateCall(operatorSignature.getName(), equalsFunction, (List<ByteCodeNode>)ImmutableList.of((Object)this.cast(generatorContext, new ByteCodeBlock().dup(firstType.getJavaType()), firstType, commonType), (Object)this.cast(generatorContext, generatorContext.generate(second), secondType, commonType)));
        ByteCodeBlock conditionBlock = new ByteCodeBlock().append(equalsCall).append(ByteCodeUtils.ifWasNullClearPopAndGoto(scope, notMatch, Void.TYPE, Boolean.TYPE));
        ByteCodeBlock trueBlock = new ByteCodeBlock().append(generatorContext.wasNull().set(ByteCodeExpressions.constantTrue())).pop(first.getType().getJavaType()).pushJavaDefault(first.getType().getJavaType());
        block.append(new IfStatement().condition(conditionBlock).ifTrue(trueBlock).ifFalse(notMatch));
        return block;
    }

    private ByteCodeNode cast(ByteCodeGeneratorContext generatorContext, ByteCodeNode argument, Type fromType, Type toType) {
        Signature function = generatorContext.getRegistry().getCoercion(fromType, toType);
        return generatorContext.generateCall(function.getName(), generatorContext.getRegistry().getScalarFunctionImplementation(function), (List<ByteCodeNode>)ImmutableList.of((Object)argument));
    }
}

