/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.ByteCodeGenerator;
import com.facebook.presto.sql.gen.ByteCodeGeneratorContext;
import com.facebook.presto.sql.relational.RowExpression;
import java.util.ArrayList;
import java.util.List;

public class FunctionCallCodeGenerator
implements ByteCodeGenerator {
    @Override
    public ByteCodeNode generateExpression(Signature signature, ByteCodeGeneratorContext context, Type returnType, List<RowExpression> arguments) {
        FunctionRegistry registry = context.getRegistry();
        ScalarFunctionImplementation function = registry.getScalarFunctionImplementation(signature);
        ArrayList<ByteCodeNode> argumentsByteCode = new ArrayList<ByteCodeNode>();
        for (RowExpression argument : arguments) {
            argumentsByteCode.add(context.generate(argument));
        }
        return context.generateCall(signature.getName(), function, argumentsByteCode);
    }
}

