/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.ByteCodeGenerator;
import com.facebook.presto.sql.gen.ByteCodeGeneratorContext;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.base.Preconditions;
import java.util.List;

public class AndCodeGenerator
implements ByteCodeGenerator {
    @Override
    public ByteCodeNode generateExpression(Signature signature, ByteCodeGeneratorContext generator, Type returnType, List<RowExpression> arguments) {
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        Variable wasNull = generator.wasNull();
        ByteCodeBlock block = new ByteCodeBlock().comment("AND").setDescription("AND");
        ByteCodeNode left = generator.generate(arguments.get(0));
        ByteCodeNode right = generator.generate(arguments.get(1));
        block.append(left);
        IfStatement ifLeftIsNull = new IfStatement("if left wasNull...", new Object[0]).condition(wasNull);
        LabelNode end = new LabelNode("end");
        ifLeftIsNull.ifTrue().comment("clear the null flag, pop left value off stack, and push left null flag on the stack (true)").append(wasNull.set(ByteCodeExpressions.constantFalse())).pop(arguments.get(0).getType().getJavaType()).push(true);
        LabelNode leftIsTrue = new LabelNode("leftIsTrue");
        ifLeftIsNull.ifFalse().comment("if left is false, push false, and goto end").ifTrueGoto(leftIsTrue).push(false).gotoLabel(end).comment("left was true; push left null flag on the stack (false)").visitLabel(leftIsTrue).push(false);
        block.append(ifLeftIsNull);
        block.append(right);
        IfStatement ifRightIsNull = new IfStatement("if right wasNull...", new Object[0]);
        ifRightIsNull.condition().append(wasNull);
        ifRightIsNull.ifTrue().comment("right was null, pop the right value off the stack; wasNull flag remains set to TRUE").pop(arguments.get(1).getType().getJavaType());
        LabelNode rightIsTrue = new LabelNode("rightIsTrue");
        ifRightIsNull.ifFalse().comment("if right is false, pop left null flag off stack, push false and goto end").ifTrueGoto(rightIsTrue).pop(Boolean.TYPE).push(false).gotoLabel(end).comment("right was true; store left null flag (on stack) in wasNull variable, and push true").visitLabel(rightIsTrue).putVariable(wasNull).push(true);
        block.append(ifRightIsNull).visitLabel(end);
        return block;
    }
}

