/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Table;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Analysis {
    private Query query;
    private String updateType;
    private final IdentityHashMap<Table, Query> namedQueries = new IdentityHashMap();
    private TupleDescriptor outputDescriptor;
    private final IdentityHashMap<Node, TupleDescriptor> outputDescriptors = new IdentityHashMap();
    private final IdentityHashMap<Expression, Integer> resolvedNames = new IdentityHashMap();
    private final IdentityHashMap<QuerySpecification, List<FunctionCall>> aggregates = new IdentityHashMap();
    private final IdentityHashMap<QuerySpecification, List<FieldOrExpression>> groupByExpressions = new IdentityHashMap();
    private final IdentityHashMap<Node, Expression> where = new IdentityHashMap();
    private final IdentityHashMap<QuerySpecification, Expression> having = new IdentityHashMap();
    private final IdentityHashMap<Node, List<FieldOrExpression>> orderByExpressions = new IdentityHashMap();
    private final IdentityHashMap<Node, List<FieldOrExpression>> outputExpressions = new IdentityHashMap();
    private final IdentityHashMap<QuerySpecification, List<FunctionCall>> windowFunctions = new IdentityHashMap();
    private final IdentityHashMap<Join, Expression> joins = new IdentityHashMap();
    private final SetMultimap<Node, InPredicate> inPredicates = HashMultimap.create();
    private final IdentityHashMap<Join, JoinInPredicates> joinInPredicates = new IdentityHashMap();
    private final IdentityHashMap<Table, TableHandle> tables = new IdentityHashMap();
    private final IdentityHashMap<Expression, Type> types = new IdentityHashMap();
    private final IdentityHashMap<Expression, Type> coercions = new IdentityHashMap();
    private final IdentityHashMap<Relation, Type[]> relationCoercions = new IdentityHashMap();
    private final IdentityHashMap<FunctionCall, Signature> functionSignature = new IdentityHashMap();
    private final IdentityHashMap<Field, ColumnHandle> columns = new IdentityHashMap();
    private final IdentityHashMap<SampledRelation, Double> sampleRatios = new IdentityHashMap();
    private Optional<QualifiedTableName> createTableDestination = Optional.empty();
    private Map<String, Expression> createTableProperties = ImmutableMap.of();
    private boolean createTableAsSelectWithData = true;
    private Optional<TableHandle> insertTarget = Optional.empty();
    private Optional<Delete> delete = Optional.empty();

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public String getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    public boolean isCreateTableAsSelectWithData() {
        return this.createTableAsSelectWithData;
    }

    public void setCreateTableAsSelectWithData(boolean createTableAsSelectWithData) {
        this.createTableAsSelectWithData = createTableAsSelectWithData;
    }

    public void addResolvedNames(Map<Expression, Integer> mappings) {
        this.resolvedNames.putAll(mappings);
    }

    public Optional<Integer> getFieldIndex(Expression expression) {
        return Optional.ofNullable(this.resolvedNames.get(expression));
    }

    public void setAggregates(QuerySpecification node, List<FunctionCall> aggregates) {
        this.aggregates.put(node, aggregates);
    }

    public List<FunctionCall> getAggregates(QuerySpecification query) {
        return this.aggregates.get(query);
    }

    public IdentityHashMap<Expression, Type> getTypes() {
        return new IdentityHashMap<Expression, Type>(this.types);
    }

    public Type getType(Expression expression) {
        Preconditions.checkArgument((boolean)this.types.containsKey(expression), (String)"Expression not analyzed: %s", (Object[])new Object[]{expression});
        return this.types.get(expression);
    }

    public Type[] getRelationCoercion(Relation relation) {
        return this.relationCoercions.get(relation);
    }

    public void addRelationCoercion(Relation relation, Type[] types) {
        this.relationCoercions.put(relation, types);
    }

    public IdentityHashMap<Expression, Type> getCoercions() {
        return this.coercions;
    }

    public Type getCoercion(Expression expression) {
        return this.coercions.get(expression);
    }

    public void setGroupByExpressions(QuerySpecification node, List<FieldOrExpression> expressions) {
        this.groupByExpressions.put(node, expressions);
    }

    public List<FieldOrExpression> getGroupByExpressions(QuerySpecification node) {
        return this.groupByExpressions.get(node);
    }

    public void setWhere(Node node, Expression expression) {
        this.where.put(node, expression);
    }

    public Expression getWhere(QuerySpecification node) {
        return this.where.get(node);
    }

    public void setOrderByExpressions(Node node, List<FieldOrExpression> items) {
        this.orderByExpressions.put(node, items);
    }

    public List<FieldOrExpression> getOrderByExpressions(Node node) {
        return this.orderByExpressions.get(node);
    }

    public void setOutputExpressions(Node node, List<FieldOrExpression> expressions) {
        this.outputExpressions.put(node, expressions);
    }

    public List<FieldOrExpression> getOutputExpressions(Node node) {
        return this.outputExpressions.get(node);
    }

    public void setHaving(QuerySpecification node, Expression expression) {
        this.having.put(node, expression);
    }

    public void setJoinCriteria(Join node, Expression criteria) {
        this.joins.put(node, criteria);
    }

    public Expression getJoinCriteria(Join join) {
        return this.joins.get(join);
    }

    public void addInPredicates(Node node, Set<InPredicate> inPredicates) {
        this.inPredicates.putAll((Object)node, inPredicates);
    }

    public Set<InPredicate> getInPredicates(Node node) {
        return this.inPredicates.get((Object)node);
    }

    public void addJoinInPredicates(Join node, JoinInPredicates joinInPredicates) {
        this.joinInPredicates.put(node, joinInPredicates);
    }

    public JoinInPredicates getJoinInPredicates(Join node) {
        return this.joinInPredicates.get(node);
    }

    public void setWindowFunctions(QuerySpecification node, List<FunctionCall> functions) {
        this.windowFunctions.put(node, functions);
    }

    public Map<QuerySpecification, List<FunctionCall>> getWindowFunctions() {
        return this.windowFunctions;
    }

    public List<FunctionCall> getWindowFunctions(QuerySpecification query) {
        return this.windowFunctions.get(query);
    }

    public void setOutputDescriptor(TupleDescriptor descriptor) {
        this.outputDescriptor = descriptor;
    }

    public TupleDescriptor getOutputDescriptor() {
        return this.outputDescriptor;
    }

    public void setOutputDescriptor(Node node, TupleDescriptor descriptor) {
        this.outputDescriptors.put(node, descriptor);
    }

    public TupleDescriptor getOutputDescriptor(Node node) {
        Preconditions.checkState((boolean)this.outputDescriptors.containsKey(node), (String)"Output descriptor missing for %s. Broken analysis?", (Object[])new Object[]{node});
        return this.outputDescriptors.get(node);
    }

    public TableHandle getTableHandle(Table table) {
        return this.tables.get(table);
    }

    public void registerTable(Table table, TableHandle handle) {
        this.tables.put(table, handle);
    }

    public Signature getFunctionSignature(FunctionCall function) {
        return this.functionSignature.get(function);
    }

    public void addFunctionSignatures(IdentityHashMap<FunctionCall, Signature> infos) {
        this.functionSignature.putAll(infos);
    }

    public Set<Expression> getColumnReferences() {
        return this.resolvedNames.keySet();
    }

    public void addTypes(IdentityHashMap<Expression, Type> types) {
        this.types.putAll(types);
    }

    public void addCoercion(Expression expression, Type type) {
        this.coercions.put(expression, type);
    }

    public void addCoercions(IdentityHashMap<Expression, Type> coercions) {
        this.coercions.putAll(coercions);
    }

    public Expression getHaving(QuerySpecification query) {
        return this.having.get(query);
    }

    public void setColumn(Field field, ColumnHandle handle) {
        this.columns.put(field, handle);
    }

    public ColumnHandle getColumn(Field field) {
        return this.columns.get(field);
    }

    public void setCreateTableDestination(QualifiedTableName destination) {
        this.createTableDestination = Optional.of(destination);
    }

    public Optional<QualifiedTableName> getCreateTableDestination() {
        return this.createTableDestination;
    }

    public void setCreateTableProperties(Map<String, Expression> createTableProperties) {
        this.createTableProperties = createTableProperties;
    }

    public Map<String, Expression> getCreateTableProperties() {
        return this.createTableProperties;
    }

    public void setInsertTarget(TableHandle target) {
        this.insertTarget = Optional.of(target);
    }

    public Optional<TableHandle> getInsertTarget() {
        return this.insertTarget;
    }

    public void setDelete(Delete delete) {
        this.delete = Optional.of(delete);
    }

    public Optional<Delete> getDelete() {
        return this.delete;
    }

    public Query getNamedQuery(Table table) {
        return this.namedQueries.get(table);
    }

    public void registerNamedQuery(Table tableReference, Query query) {
        Objects.requireNonNull(tableReference, "tableReference is null");
        Objects.requireNonNull(query, "query is null");
        this.namedQueries.put(tableReference, query);
    }

    public void setSampleRatio(SampledRelation relation, double ratio) {
        this.sampleRatios.put(relation, ratio);
    }

    public double getSampleRatio(SampledRelation relation) {
        Preconditions.checkState((boolean)this.sampleRatios.containsKey(relation), (String)"Sample ratio missing for %s. Broken analysis?", (Object[])new Object[]{relation});
        return this.sampleRatios.get(relation);
    }

    public static class JoinInPredicates {
        private final Set<InPredicate> leftInPredicates;
        private final Set<InPredicate> rightInPredicates;

        public JoinInPredicates(Set<InPredicate> leftInPredicates, Set<InPredicate> rightInPredicates) {
            this.leftInPredicates = ImmutableSet.copyOf((Collection)Objects.requireNonNull(leftInPredicates, "leftInPredicates is null"));
            this.rightInPredicates = ImmutableSet.copyOf((Collection)Objects.requireNonNull(rightInPredicates, "rightInPredicates is null"));
        }

        public Set<InPredicate> getLeftInPredicates() {
            return this.leftInPredicates;
        }

        public Set<InPredicate> getRightInPredicates() {
            return this.rightInPredicates;
        }

        public int hashCode() {
            return Objects.hash(this.leftInPredicates, this.rightInPredicates);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            JoinInPredicates other = (JoinInPredicates)obj;
            return Objects.equals(this.leftInPredicates, other.leftInPredicates) && Objects.equals(this.rightInPredicates, other.rightInPredicates);
        }
    }
}

