/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.Session;
import com.facebook.presto.client.ClientSession;
import com.facebook.presto.client.Column;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StatementClient;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.server.ForExecute;
import com.facebook.presto.server.ResourceUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import io.airlift.http.client.HttpClient;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.json.JsonCodec;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/v1/execute")
public class ExecuteResource {
    private final HttpServerInfo serverInfo;
    private final AccessControl accessControl;
    private final SessionPropertyManager sessionPropertyManager;
    private final HttpClient httpClient;
    private final QueryIdGenerator queryIdGenerator;
    private final JsonCodec<QueryResults> queryResultsCodec;

    @Inject
    public ExecuteResource(HttpServerInfo serverInfo, AccessControl accessControl, SessionPropertyManager sessionPropertyManager, @ForExecute HttpClient httpClient, QueryIdGenerator queryIdGenerator, JsonCodec<QueryResults> queryResultsCodec) {
        this.serverInfo = Objects.requireNonNull(serverInfo, "serverInfo is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.queryIdGenerator = Objects.requireNonNull(queryIdGenerator, "queryIdGenerator is null");
        this.queryResultsCodec = Objects.requireNonNull(queryResultsCodec, "queryResultsCodec is null");
    }

    @POST
    @Produces(value={"application/json"})
    public Response createQuery(String query, @Context HttpServletRequest servletRequest) {
        ResourceUtil.assertRequest(!Strings.isNullOrEmpty((String)query), "SQL query is empty", new Object[0]);
        Session session = ResourceUtil.createSessionForRequest(servletRequest, this.accessControl, this.sessionPropertyManager, this.queryIdGenerator.createNextQueryId());
        ClientSession clientSession = session.toClientSession(this.serverUri(), false);
        StatementClient client = new StatementClient(this.httpClient, this.queryResultsCodec, clientSession, query);
        List<Column> columns = ExecuteResource.getColumns(client);
        Iterator<List<Object>> iterator = ExecuteResource.flatten(new ResultsPageIterator(client));
        SimpleQueryResults results = new SimpleQueryResults(columns, iterator);
        return Response.ok((Object)results, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    private URI serverUri() {
        Preconditions.checkState((this.serverInfo.getHttpUri() != null ? 1 : 0) != 0, (Object)"No HTTP URI for this server (HTTP disabled?)");
        return this.serverInfo.getHttpUri();
    }

    private static List<Column> getColumns(StatementClient client) {
        while (client.isValid()) {
            List columns = client.current().getColumns();
            if (columns != null) {
                return columns;
            }
            client.advance();
        }
        if (!client.isFailed()) {
            throw ExecuteResource.internalServerError("No columns");
        }
        throw ExecuteResource.internalServerError(ExecuteResource.failureMessage(client.finalResults()));
    }

    private static <T> Iterator<T> flatten(Iterator<Iterable<T>> iterator) {
        return Iterators.concat((Iterator)Iterators.transform(iterator, Iterable::iterator));
    }

    private static WebApplicationException internalServerError(String message) {
        return new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).build());
    }

    private static String failureMessage(QueryResults results) {
        return String.format("Query failed (#%s): %s", results.getId(), results.getError().getMessage());
    }

    public static class SimpleQueryResults {
        private final List<Column> columns;
        private final Iterator<List<Object>> data;

        public SimpleQueryResults(List<Column> columns, Iterator<List<Object>> data) {
            this.columns = Objects.requireNonNull(columns, "columns is null");
            this.data = Objects.requireNonNull(data, "data is null");
        }

        @JsonProperty
        public List<Column> getColumns() {
            return this.columns;
        }

        @JsonProperty
        public Iterator<List<Object>> getData() {
            return this.data;
        }
    }

    private static class ResultsPageIterator
    extends AbstractIterator<Iterable<List<Object>>> {
        private final StatementClient client;

        private ResultsPageIterator(StatementClient client) {
            this.client = Objects.requireNonNull(client, "client is null");
        }

        protected Iterable<List<Object>> computeNext() {
            while (this.client.isValid()) {
                Iterable data = this.client.current().getData();
                this.client.advance();
                if (data == null) continue;
                return data;
            }
            if (this.client.isFailed()) {
                throw ExecuteResource.internalServerError(ExecuteResource.failureMessage(this.client.finalResults()));
            }
            return (Iterable)this.endOfData();
        }
    }
}

