/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricOperator;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MapEqualOperator
extends ParametricOperator {
    public static final MapEqualOperator MAP_EQUAL = new MapEqualOperator();
    private static final TypeSignature RETURN_TYPE = TypeSignature.parseTypeSignature((String)"boolean");
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapEqualOperator.class, "equals", MethodHandle.class, MethodHandle.class, MethodHandle.class, Type.class, Type.class, Block.class, Block.class);

    private MapEqualOperator() {
        super(OperatorType.EQUAL, (List<TypeParameter>)ImmutableList.of((Object)Signature.comparableTypeParameter("K"), (Object)Signature.comparableTypeParameter("V")), "boolean", (List<String>)ImmutableList.of((Object)"map<K,V>", (Object)"map<K,V>"));
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        Type type = typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)keyType.getTypeSignature(), (Object)valueType.getTypeSignature()), (List)ImmutableList.of());
        TypeSignature typeSignature = type.getTypeSignature();
        MethodHandle keyEqualsFunction = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(OperatorType.EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)keyType, (Object)keyType))).getMethodHandle();
        MethodHandle keyHashcodeFunction = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(OperatorType.HASH_CODE, (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)keyType))).getMethodHandle();
        MethodHandle valueEqualsFunction = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(OperatorType.EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)valueType, (Object)valueType))).getMethodHandle();
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(keyEqualsFunction).bindTo(keyHashcodeFunction).bindTo(valueEqualsFunction).bindTo(keyType).bindTo(valueType);
        return FunctionRegistry.operatorInfo(OperatorType.EQUAL, RETURN_TYPE, (List<TypeSignature>)ImmutableList.of((Object)typeSignature, (Object)typeSignature), methodHandle, true, (List<Boolean>)ImmutableList.of((Object)false, (Object)false));
    }

    public static Boolean equals(MethodHandle keyEqualsFunction, MethodHandle keyHashcodeFunction, MethodHandle valueEqualsFunction, Type keyType, Type valueType, Block leftMapBlock, Block rightMapBlock) {
        LinkedHashMap<KeyWrapper, Integer> wrappedLeftMap = new LinkedHashMap<KeyWrapper, Integer>();
        for (int position = 0; position < leftMapBlock.getPositionCount(); position += 2) {
            wrappedLeftMap.put(new KeyWrapper(TypeUtils.castValue(keyType, leftMapBlock, position), keyEqualsFunction, keyHashcodeFunction), position + 1);
        }
        LinkedHashMap<KeyWrapper, Integer> wrappedRightMap = new LinkedHashMap<KeyWrapper, Integer>();
        for (int position = 0; position < rightMapBlock.getPositionCount(); position += 2) {
            wrappedRightMap.put(new KeyWrapper(TypeUtils.castValue(keyType, rightMapBlock, position), keyEqualsFunction, keyHashcodeFunction), position + 1);
        }
        if (wrappedLeftMap.size() != wrappedRightMap.size()) {
            return false;
        }
        for (Map.Entry entry : wrappedRightMap.entrySet()) {
            KeyWrapper key = (KeyWrapper)entry.getKey();
            Integer leftValuePosition = (Integer)wrappedLeftMap.get(key);
            if (leftValuePosition == null) {
                return false;
            }
            Object leftValue = TypeUtils.castValue(valueType, leftMapBlock, leftValuePosition);
            if (leftValue == null) {
                return null;
            }
            Object rightValue = TypeUtils.castValue(valueType, rightMapBlock, (Integer)entry.getValue());
            if (rightValue == null) {
                return null;
            }
            try {
                Boolean result = valueEqualsFunction.invoke(leftValue, rightValue);
                if (result == null) {
                    return null;
                }
                if (result.booleanValue()) continue;
                return false;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        return true;
    }

    private static final class KeyWrapper {
        private final Object key;
        private final MethodHandle hashCode;
        private final MethodHandle equals;

        public KeyWrapper(Object key, MethodHandle equals, MethodHandle hashCode) {
            this.key = key;
            this.equals = equals;
            this.hashCode = hashCode;
        }

        public int hashCode() {
            try {
                return Long.hashCode(this.hashCode.invoke(this.key));
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }

        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            KeyWrapper other = (KeyWrapper)obj;
            try {
                return this.equals.invoke(this.key, other.key);
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
    }
}

