/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.FunctionType;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public final class MapConstructor
implements ParametricFunction {
    public static final MapConstructor MAP_CONSTRUCTOR = new MapConstructor();
    private static final Signature SIGNATURE = new Signature("map", FunctionType.SCALAR, (List<TypeParameter>)ImmutableList.of((Object)Signature.comparableTypeParameter("K"), (Object)Signature.typeParameter("V")), "map<K,V>", (List<String>)ImmutableList.of((Object)"array<K>", (Object)"array<V>"), false);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapConstructor.class, "createMap", MapType.class, Block.class, Block.class);
    private static final String DESCRIPTION = "Constructs a map from the given key/value arrays";

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        Type mapType = typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)keyType.getTypeSignature(), (Object)valueType.getTypeSignature()), (List)ImmutableList.of());
        ImmutableList argumentTypes = ImmutableList.of((Object)TypeUtils.parameterizedTypeName("array", keyType.getTypeSignature()), (Object)TypeUtils.parameterizedTypeName("array", valueType.getTypeSignature()));
        Signature signature = new Signature("map", FunctionType.SCALAR, (List<TypeParameter>)ImmutableList.of(), mapType.getTypeSignature(), (List<TypeSignature>)argumentTypes, false);
        return new FunctionInfo(signature, DESCRIPTION, this.isHidden(), METHOD_HANDLE.bindTo(mapType), this.isDeterministic(), false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false));
    }

    public static Block createMap(MapType mapType, Block keyBlock, Block valueBlock) {
        InterleavedBlockBuilder blockBuilder = new InterleavedBlockBuilder(mapType.getTypeParameters(), new BlockBuilderStatus(), keyBlock.getPositionCount() * 2);
        Failures.checkCondition(keyBlock.getPositionCount() == valueBlock.getPositionCount(), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Key and value arrays must be the same length", new Object[0]);
        for (int i = 0; i < keyBlock.getPositionCount(); ++i) {
            if (keyBlock.isNull(i)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be null");
            }
            mapType.getKeyType().appendTo(keyBlock, i, (BlockBuilder)blockBuilder);
            mapType.getValueType().appendTo(valueBlock, i, (BlockBuilder)blockBuilder);
        }
        return blockBuilder.build();
    }
}

