/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.FunctionType;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ArrayRemoveFunction
implements ParametricFunction {
    public static final ArrayRemoveFunction ARRAY_REMOVE_FUNCTION = new ArrayRemoveFunction();
    private static final String FUNCTION_NAME = "array_remove";
    private static final Signature SIGNATURE = new Signature("array_remove", FunctionType.SCALAR, (List<TypeParameter>)ImmutableList.of((Object)Signature.comparableTypeParameter("E")), "array<E>", (List<String>)ImmutableList.of((Object)"array<E>", (Object)"E"), false);
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(ArrayRemoveFunction.class, "remove", MethodHandle.class, Type.class, Block.class, Boolean.TYPE);
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(ArrayRemoveFunction.class, "remove", MethodHandle.class, Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(ArrayRemoveFunction.class, "remove", MethodHandle.class, Type.class, Block.class, Double.TYPE);
    private static final MethodHandle METHOD_HANDLE_SLICE = Reflection.methodHandle(ArrayRemoveFunction.class, "remove", MethodHandle.class, Type.class, Block.class, Slice.class);
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(ArrayRemoveFunction.class, "remove", MethodHandle.class, Type.class, Block.class, Object.class);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Remove specified values from the given array";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (Object)String.format("%s expects only one argument", FUNCTION_NAME));
        Type type = types.get("E");
        TypeSignature valueType = type.getTypeSignature();
        TypeSignature arrayType = TypeUtils.parameterizedTypeName("array", valueType);
        MethodHandle equalsFunction = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(OperatorType.EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))).getMethodHandle();
        MethodHandle baseMethodHandle = type.getJavaType() == Long.TYPE ? METHOD_HANDLE_LONG : (type.getJavaType() == Double.TYPE ? METHOD_HANDLE_DOUBLE : (type.getJavaType() == Slice.class ? METHOD_HANDLE_SLICE : (type.getJavaType() == Boolean.TYPE ? METHOD_HANDLE_BOOLEAN : METHOD_HANDLE_OBJECT)));
        MethodHandle methodHandle = baseMethodHandle.bindTo(equalsFunction).bindTo(type);
        Signature signature = new Signature(FUNCTION_NAME, FunctionType.SCALAR, arrayType, arrayType, valueType);
        return new FunctionInfo(signature, this.getDescription(), this.isHidden(), methodHandle, this.isDeterministic(), false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false));
    }

    public static Block remove(MethodHandle equalsFunction, Type type, Block array, Slice value) {
        return ArrayRemoveFunction.remove(equalsFunction, type, array, (Object)value);
    }

    public static Block remove(MethodHandle equalsFunction, Type type, Block array, long value) {
        return ArrayRemoveFunction.remove(equalsFunction, type, array, (Object)value);
    }

    public static Block remove(MethodHandle equalsFunction, Type type, Block array, double value) {
        return ArrayRemoveFunction.remove(equalsFunction, type, array, (Object)value);
    }

    public static Block remove(MethodHandle equalsFunction, Type type, Block array, boolean value) {
        return ArrayRemoveFunction.remove(equalsFunction, type, array, (Object)value);
    }

    public static Block remove(MethodHandle equalsFunction, Type type, Block array, Object value) {
        int sizeAfterRemove = 0;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (int i = 0; i < array.getPositionCount(); ++i) {
            Object element = TypeUtils.castValue(type, array, i);
            try {
                if (element != null && equalsFunction.invoke(element, value)) continue;
                positions.add(i);
                sizeAfterRemove += array.getLength(i);
                continue;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        if (array.getPositionCount() == positions.size()) {
            return array;
        }
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), sizeAfterRemove);
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            int position = (Integer)iterator.next();
            type.appendTo(array, position, blockBuilder);
        }
        return blockBuilder.build();
    }
}

