/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.FunctionType;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ArrayElementAtFunction
implements ParametricFunction {
    public static final ArrayElementAtFunction ARRAY_ELEMENT_AT_FUNCTION = new ArrayElementAtFunction();
    private static final String FUNCTION_NAME = "element_at";
    private static final Signature SIGNATURE = new Signature("element_at", FunctionType.SCALAR, (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("E")), "E", (List<String>)ImmutableList.of((Object)"array<E>", (Object)"bigint"), false);
    private static final Map<Class<?>, MethodHandle> METHOD_HANDLES = ImmutableMap.builder().put(Boolean.TYPE, (Object)Reflection.methodHandle(ArrayElementAtFunction.class, "booleanElementAt", Type.class, Block.class, Long.TYPE)).put(Long.TYPE, (Object)Reflection.methodHandle(ArrayElementAtFunction.class, "longElementAt", Type.class, Block.class, Long.TYPE)).put(Double.TYPE, (Object)Reflection.methodHandle(ArrayElementAtFunction.class, "doubleElementAt", Type.class, Block.class, Long.TYPE)).put(Slice.class, (Object)Reflection.methodHandle(ArrayElementAtFunction.class, "sliceElementAt", Type.class, Block.class, Long.TYPE)).put(Void.TYPE, (Object)Reflection.methodHandle(ArrayElementAtFunction.class, "voidElementAt", Type.class, Block.class, Long.TYPE)).build();
    private static final MethodHandle OBJECT_METHOD_HANDLE = Reflection.methodHandle(ArrayElementAtFunction.class, "objectElementAt", Type.class, Block.class, Long.TYPE);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Get element of array at given index";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        MethodHandle methodHandle;
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (String)"Expected one type, got %s", (Object[])new Object[]{types});
        Type elementType = types.get("E");
        if (METHOD_HANDLES.containsKey(elementType.getJavaType())) {
            methodHandle = METHOD_HANDLES.get(elementType.getJavaType());
        } else {
            Preconditions.checkArgument((!elementType.getJavaType().isPrimitive() ? 1 : 0) != 0, (Object)("Unsupported primitive type: " + elementType.getJavaType()));
            methodHandle = OBJECT_METHOD_HANDLE;
        }
        Objects.requireNonNull(methodHandle, "methodHandle is null");
        methodHandle = methodHandle.bindTo(elementType);
        Signature signature = new Signature(FUNCTION_NAME, FunctionType.SCALAR, elementType.getTypeSignature(), TypeUtils.parameterizedTypeName("array", elementType.getTypeSignature()), TypeSignature.parseTypeSignature((String)"bigint"));
        return new FunctionInfo(signature, this.getDescription(), this.isHidden(), methodHandle, this.isDeterministic(), true, (List<Boolean>)ImmutableList.of((Object)false, (Object)false));
    }

    public static void voidElementAt(Type elementType, Block array, long index) {
        ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
    }

    public static Long longElementAt(Type elementType, Block array, long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getLong(array, position);
    }

    public static Boolean booleanElementAt(Type elementType, Block array, long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getBoolean(array, position);
    }

    public static Double doubleElementAt(Type elementType, Block array, long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getDouble(array, position);
    }

    public static Slice sliceElementAt(Type elementType, Block array, long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getSlice(array, position);
    }

    public static Object objectElementAt(Type elementType, Block array, long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getObject(array, position);
    }

    private static int checkedIndexToBlockPosition(Block block, long index) {
        int arrayLength = block.getPositionCount();
        if (index == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "SQL array indices start at 1");
        }
        if (Math.abs(index) > (long)arrayLength) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array subscript out of bounds");
        }
        if (index > 0L) {
            return Ints.checkedCast((long)(index - 1L));
        }
        return Ints.checkedCast((long)((long)arrayLength + index));
    }
}

