/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationCompiler;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.ApproximateLongPercentileAggregations;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.LongDoubleConverterUtil;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.DigestAndPercentileState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.stats.QuantileDigest;
import java.util.List;

@AggregationFunction(value="approx_percentile")
public final class ApproximateDoublePercentileAggregations {
    public static final InternalAggregationFunction DOUBLE_APPROXIMATE_PERCENTILE_AGGREGATION = new AggregationCompiler().generateAggregationFunction(ApproximateDoublePercentileAggregations.class, (Type)DoubleType.DOUBLE, (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
    public static final InternalAggregationFunction DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION = new AggregationCompiler().generateAggregationFunction(ApproximateDoublePercentileAggregations.class, (Type)DoubleType.DOUBLE, (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE));

    private ApproximateDoublePercentileAggregations() {
    }

    @InputFunction
    public static void input(DigestAndPercentileState state, @SqlType(value="double") double value, @SqlType(value="double") double percentile) {
        ApproximateLongPercentileAggregations.input(state, LongDoubleConverterUtil.doubleToSortableLong(value), percentile);
    }

    @InputFunction
    public static void weightedInput(DigestAndPercentileState state, @SqlType(value="double") double value, @SqlType(value="bigint") long weight, @SqlType(value="double") double percentile) {
        ApproximateLongPercentileAggregations.weightedInput(state, LongDoubleConverterUtil.doubleToSortableLong(value), weight, percentile);
    }

    @CombineFunction
    public static void combine(DigestAndPercentileState state, DigestAndPercentileState otherState) {
        ApproximateLongPercentileAggregations.combine(state, otherState);
    }

    @OutputFunction(value="double")
    public static void output(DigestAndPercentileState state, BlockBuilder out) {
        QuantileDigest digest = state.getDigest();
        double percentile = state.getPercentile();
        if (digest == null || digest.getCount() == 0.0) {
            out.appendNull();
        } else {
            Preconditions.checkState((percentile != -1.0 ? 1 : 0) != 0, (Object)"Percentile is missing");
            Failures.checkCondition(0.0 <= percentile && percentile <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile must be between 0 and 1", new Object[0]);
            DoubleType.DOUBLE.writeDouble(out, LongDoubleConverterUtil.sortableLongToDouble(digest.getQuantile(percentile)));
        }
    }
}

