/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.FunctionType;
import com.facebook.presto.metadata.ParametricAggregation;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.MaxOrMinByState;
import com.facebook.presto.operator.aggregation.state.MaxOrMinByStateFactory;
import com.facebook.presto.operator.aggregation.state.MaxOrMinByStateSerializer;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;

public abstract class AbstractMinMaxBy
extends ParametricAggregation {
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxBy.class, "output", Type.class, MaxOrMinByState.class, BlockBuilder.class);
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxBy.class, "input", Boolean.TYPE, Type.class, MaxOrMinByState.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxBy.class, "combine", Boolean.TYPE, Type.class, MaxOrMinByState.class, MaxOrMinByState.class);
    private final String name;
    private final Signature signature;
    private final boolean min;

    protected AbstractMinMaxBy(boolean min) {
        this.name = (min ? "min" : "max") + "_by";
        this.signature = new Signature(this.name, FunctionType.AGGREGATE, (List<TypeParameter>)ImmutableList.of((Object)Signature.orderableTypeParameter("K"), (Object)Signature.typeParameter("V")), "V", (List<String>)ImmutableList.of((Object)"V", (Object)"K"), false);
        this.min = min;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        Signature signature = new Signature(this.name, FunctionType.AGGREGATE, valueType.getTypeSignature(), valueType.getTypeSignature(), keyType.getTypeSignature());
        InternalAggregationFunction aggregation = this.generateAggregation(valueType, keyType);
        return new FunctionInfo(signature, this.getDescription(), aggregation);
    }

    private InternalAggregationFunction generateAggregation(Type valueType, Type keyType) {
        DynamicClassLoader classLoader = new DynamicClassLoader(this.getClass().getClassLoader());
        MaxOrMinByStateSerializer stateSerializer = new MaxOrMinByStateSerializer(valueType, keyType);
        Type intermediateType = stateSerializer.getSerializedType();
        ImmutableList inputTypes = ImmutableList.of((Object)valueType, (Object)keyType);
        MaxOrMinByStateFactory stateFactory = new MaxOrMinByStateFactory();
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(this.name, valueType, (List<Type>)inputTypes), AbstractMinMaxBy.createInputParameterMetadata(valueType, keyType), MethodHandles.insertArguments(INPUT_FUNCTION, 0, this.min).bindTo(keyType), null, null, MethodHandles.insertArguments(COMBINE_FUNCTION, 0, this.min).bindTo(keyType), OUTPUT_FUNCTION.bindTo(valueType), MaxOrMinByState.class, stateSerializer, stateFactory, valueType, false);
        GenericAccumulatorFactoryBinder factory = new AccumulatorCompiler().generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(this.name, (List<Type>)inputTypes, intermediateType, valueType, true, false, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type value, Type key) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, value), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, key), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(boolean min, Type keyType, MaxOrMinByState state, Block value, Block key, int position) {
        if (state.getKey() == null || state.getKey().isNull(0) || AbstractMinMaxBy.compare(keyType.compareTo(key, position, state.getKey(), 0), min)) {
            state.setKey(key.getSingleValueBlock(position));
            state.setValue(value.getSingleValueBlock(position));
        }
    }

    public static void combine(boolean min, Type keyType, MaxOrMinByState state, MaxOrMinByState otherState) {
        Block key = state.getKey();
        Block otherKey = otherState.getKey();
        if (key == null || otherKey != null && AbstractMinMaxBy.compare(keyType.compareTo(otherKey, 0, key, 0), min)) {
            state.setKey(otherKey);
            state.setValue(otherState.getValue());
        }
    }

    public static void output(Type valueType, MaxOrMinByState state, BlockBuilder out) {
        if (state.getValue() == null) {
            out.appendNull();
        } else {
            valueType.appendTo(state.getValue(), 0, out);
        }
    }

    private static boolean compare(int value, boolean lessThan) {
        return lessThan ? value < 0 : value > 0;
    }
}

