/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TableWriterOperator
implements Operator {
    public static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY);
    private final OperatorContext operatorContext;
    private final ConnectorPageSink pageSink;
    private final Optional<Integer> sampleWeightChannel;
    private final List<Integer> inputChannels;
    private State state = State.RUNNING;
    private long rowCount;
    private boolean committed;
    private boolean closed;

    public TableWriterOperator(OperatorContext operatorContext, ConnectorPageSink pageSink, List<Integer> inputChannels, Optional<Integer> sampleWeightChannel) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.pageSink = Objects.requireNonNull(pageSink, "pageSink is null");
        this.sampleWeightChannel = Objects.requireNonNull(sampleWeightChannel, "sampleWeightChannel is null");
        this.inputChannels = Objects.requireNonNull(inputChannels, "inputChannels is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return TYPES;
    }

    @Override
    public void finish() {
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.RUNNING;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.state == State.RUNNING ? 1 : 0) != 0, (String)"Operator is %s", (Object[])new Object[]{this.state});
        Block[] blocks = new Block[this.inputChannels.size()];
        for (int outputChannel = 0; outputChannel < this.inputChannels.size(); ++outputChannel) {
            blocks[outputChannel] = page.getBlock(this.inputChannels.get(outputChannel).intValue());
        }
        Block sampleWeightBlock = null;
        if (this.sampleWeightChannel.isPresent()) {
            sampleWeightBlock = page.getBlock(this.sampleWeightChannel.get().intValue());
        }
        this.pageSink.appendPage(new Page(blocks), sampleWeightBlock);
        this.rowCount += (long)page.getPositionCount();
    }

    @Override
    public Page getOutput() {
        if (this.state != State.FINISHING) {
            return null;
        }
        this.state = State.FINISHED;
        Collection fragments = this.pageSink.commit();
        this.committed = true;
        PageBuilder page = new PageBuilder(TYPES);
        BlockBuilder rowsBuilder = page.getBlockBuilder(0);
        BlockBuilder fragmentBuilder = page.getBlockBuilder(1);
        page.declarePosition();
        BigintType.BIGINT.writeLong(rowsBuilder, this.rowCount);
        fragmentBuilder.appendNull();
        for (Slice fragment : fragments) {
            page.declarePosition();
            rowsBuilder.appendNull();
            VarbinaryType.VARBINARY.writeSlice(fragmentBuilder, fragment);
        }
        return page.build();
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.closed = true;
            if (!this.committed) {
                this.pageSink.rollback();
            }
        }
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class TableWriterOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PageSinkManager pageSinkManager;
        private final TableWriterNode.WriterTarget target;
        private final List<Integer> inputChannels;
        private final Optional<Integer> sampleWeightChannel;
        private final Session session;
        private boolean closed;

        public TableWriterOperatorFactory(int operatorId, PageSinkManager pageSinkManager, TableWriterNode.WriterTarget writerTarget, List<Integer> inputChannels, Optional<Integer> sampleWeightChannel, Session session) {
            this.operatorId = operatorId;
            this.inputChannels = Objects.requireNonNull(inputChannels, "inputChannels is null");
            this.pageSinkManager = Objects.requireNonNull(pageSinkManager, "pageSinkManager is null");
            Preconditions.checkArgument((writerTarget instanceof TableWriterNode.CreateHandle || writerTarget instanceof TableWriterNode.InsertHandle ? 1 : 0) != 0, (Object)"writerTarget must be CreateHandle or InsertHandle");
            this.target = Objects.requireNonNull(writerTarget, "writerTarget is null");
            this.sampleWeightChannel = Objects.requireNonNull(sampleWeightChannel, "sampleWeightChannel is null");
            this.session = session;
        }

        @Override
        public List<Type> getTypes() {
            return TYPES;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, TableWriterOperator.class.getSimpleName());
            return new TableWriterOperator(context, this.createPageSink(), this.inputChannels, this.sampleWeightChannel);
        }

        private ConnectorPageSink createPageSink() {
            if (this.target instanceof TableWriterNode.CreateHandle) {
                return this.pageSinkManager.createPageSink(this.session, ((TableWriterNode.CreateHandle)this.target).getHandle());
            }
            if (this.target instanceof TableWriterNode.InsertHandle) {
                return this.pageSinkManager.createPageSink(this.session, ((TableWriterNode.InsertHandle)this.target).getHandle());
            }
            throw new UnsupportedOperationException("Unhandled target type: " + this.target.getClass().getName());
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

