/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.SystemMemoryUsageListener;
import com.facebook.presto.operator.OperatorContext;
import java.util.Objects;

public class SystemMemoryUsageTracker
implements SystemMemoryUsageListener {
    private final OperatorContext operatorContext;

    public SystemMemoryUsageTracker(OperatorContext operatorContext) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
    }

    @Override
    public void updateSystemMemoryUsage(long deltaMemoryInBytes) {
        if (deltaMemoryInBytes > 0L) {
            this.operatorContext.reserveSystemMemory(deltaMemoryInBytes);
        } else {
            this.operatorContext.freeSystemMemory(-deltaMemoryInBytes);
        }
    }
}

