/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.PrecomputedHashGenerator;
import com.facebook.presto.operator.RoundRobinPartitionGenerator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public interface PartitionGenerator {
    public static PartitionGenerator createRoundRobinPartitionGenerator() {
        return new RoundRobinPartitionGenerator();
    }

    public static PartitionGenerator createHashPartitionGenerator(Optional<Integer> hashChannel, List<Integer> partitioningChannels, List<Type> types) {
        if (hashChannel.isPresent()) {
            return new PrecomputedHashGenerator(hashChannel.get());
        }
        ImmutableList.Builder hashTypes = ImmutableList.builder();
        int[] hashChannels = new int[partitioningChannels.size()];
        for (int i = 0; i < partitioningChannels.size(); ++i) {
            int channel = partitioningChannels.get(i);
            hashTypes.add((Object)types.get(channel));
            hashChannels[i] = channel;
        }
        return new InterpretedHashGenerator((List<Type>)hashTypes.build(), hashChannels);
    }

    public int getPartitionBucket(int var1, int var2, Page var3);
}

