/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.ParallelLookupSourceSupplier;
import com.facebook.presto.operator.PrecomputedHashGenerator;
import com.facebook.presto.operator.SharedLookupSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ParallelHashBuilder {
    private final List<Integer> hashChannels;
    private final Optional<Integer> hashChannel;
    private final int expectedPositions;
    private final List<SettableFuture<PagesIndex>> pagesIndexFutures;
    private final List<SettableFuture<SharedLookupSource>> lookupSourceFutures;
    private final LookupSourceSupplier lookupSourceSupplier;
    private final List<Type> types;

    public ParallelHashBuilder(List<Type> types, List<Integer> hashChannels, Optional<Integer> hashChannel, int expectedPositions, int partitionCount) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.hashChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashChannels, "hashChannels is null"));
        this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
        Preconditions.checkArgument((expectedPositions >= 0 ? 1 : 0) != 0, (Object)"expectedPositions is negative");
        this.expectedPositions = expectedPositions;
        Preconditions.checkArgument((Integer.bitCount(partitionCount) == 1 ? 1 : 0) != 0, (Object)"partitionCount must be a power of 2");
        ImmutableList.Builder pagesIndexFutures = ImmutableList.builder();
        ImmutableList.Builder lookupSourceFutures = ImmutableList.builder();
        for (int i = 0; i < partitionCount; ++i) {
            pagesIndexFutures.add((Object)SettableFuture.create());
            lookupSourceFutures.add((Object)SettableFuture.create());
        }
        this.pagesIndexFutures = pagesIndexFutures.build();
        this.lookupSourceFutures = lookupSourceFutures.build();
        this.lookupSourceSupplier = new ParallelLookupSourceSupplier(types, hashChannels, this.lookupSourceFutures);
    }

    public OperatorFactory getCollectOperatorFactory(int operatorId) {
        return new ParallelHashCollectOperatorFactory(operatorId, this.pagesIndexFutures, this.types, this.hashChannels, this.hashChannel, this.expectedPositions);
    }

    public OperatorFactory getBuildOperatorFactory() {
        return new ParallelHashBuilderOperatorFactory(0, this.types, this.pagesIndexFutures, this.lookupSourceFutures, this.hashChannels, this.hashChannel);
    }

    public LookupSourceSupplier getLookupSourceSupplier() {
        return this.lookupSourceSupplier;
    }

    private static class ParallelHashBuilderOperator
    implements Operator {
        private final OperatorContext operatorContext;
        private final List<Type> types;
        private final ListenableFuture<PagesIndex> pagesIndexFuture;
        private final SettableFuture<SharedLookupSource> lookupSourceFuture;
        private final List<Integer> hashChannels;
        private final Optional<Integer> hashChannel;
        private boolean finished;

        public ParallelHashBuilderOperator(OperatorContext operatorContext, List<Type> types, ListenableFuture<PagesIndex> pagesIndexFuture, SettableFuture<SharedLookupSource> lookupSourceFuture, List<Integer> hashChannels, Optional<Integer> hashChannel) {
            this.operatorContext = operatorContext;
            this.types = types;
            this.pagesIndexFuture = pagesIndexFuture;
            this.lookupSourceFuture = lookupSourceFuture;
            this.hashChannels = hashChannels;
            this.hashChannel = hashChannel;
        }

        @Override
        public OperatorContext getOperatorContext() {
            return this.operatorContext;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public ListenableFuture<?> isBlocked() {
            if (this.pagesIndexFuture.isDone()) {
                return NOT_BLOCKED;
            }
            return this.pagesIndexFuture;
        }

        @Override
        public void finish() {
            if (this.finished) {
                return;
            }
            PagesIndex pagesIndex = (PagesIndex)Futures.getUnchecked(this.pagesIndexFuture);
            SharedLookupSource sharedLookupSource = new SharedLookupSource(pagesIndex.createLookupSource(this.hashChannels, this.hashChannel), this.operatorContext);
            if (!this.lookupSourceFuture.set((Object)sharedLookupSource)) {
                sharedLookupSource.freeMemory();
                sharedLookupSource.close();
            }
            this.finished = true;
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }

        @Override
        public boolean needsInput() {
            return false;
        }

        @Override
        public void addInput(Page page) {
            throw new UnsupportedOperationException(this.getClass().getName() + " can not take input");
        }

        @Override
        public Page getOutput() {
            return null;
        }
    }

    private static class ParallelHashBuilderOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Type> types;
        private final List<ListenableFuture<PagesIndex>> partitionFutures;
        private final List<SettableFuture<SharedLookupSource>> lookupSourceFutures;
        private final List<Integer> hashChannels;
        private final Optional<Integer> hashChannel;
        private int partition;
        private boolean closed;

        public ParallelHashBuilderOperatorFactory(int operatorId, List<Type> types, List<? extends ListenableFuture<PagesIndex>> partitionFutures, List<SettableFuture<SharedLookupSource>> lookupSourceFutures, List<Integer> hashChannels, Optional<Integer> hashChannel) {
            this.operatorId = operatorId;
            this.types = types;
            this.partitionFutures = ImmutableList.copyOf(partitionFutures);
            this.lookupSourceFutures = lookupSourceFutures;
            this.hashChannels = hashChannels;
            this.hashChannel = hashChannel;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            Preconditions.checkState((this.partition < this.lookupSourceFutures.size() ? 1 : 0) != 0, (Object)"All operators already created");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, ParallelHashBuilder.class.getSimpleName());
            ParallelHashBuilderOperator parallelHashBuilderOperator = new ParallelHashBuilderOperator(operatorContext, this.types, this.partitionFutures.get(this.partition), this.lookupSourceFutures.get(this.partition), this.hashChannels, this.hashChannel);
            ++this.partition;
            return parallelHashBuilderOperator;
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    private static class ParallelHashCollectOperator
    implements Operator {
        private final OperatorContext operatorContext;
        private final List<SettableFuture<PagesIndex>> partitionFutures;
        private final HashGenerator hashGenerator;
        private final int parallelStreamMask;
        private final PagesIndex[] partitions;
        private final List<Type> types;
        private boolean finished;

        public ParallelHashCollectOperator(OperatorContext operatorContext, List<SettableFuture<PagesIndex>> partitionFutures, List<Type> types, List<Integer> hashChannels, Optional<Integer> hashChannel, int expectedPositions) {
            this.operatorContext = operatorContext;
            this.partitionFutures = partitionFutures;
            this.types = types;
            if (hashChannel.isPresent()) {
                this.hashGenerator = new PrecomputedHashGenerator(hashChannel.get());
            } else {
                ImmutableList.Builder hashChannelTypes = ImmutableList.builder();
                for (int channel : hashChannels) {
                    hashChannelTypes.add((Object)types.get(channel));
                }
                this.hashGenerator = new InterpretedHashGenerator((List<Type>)hashChannelTypes.build(), Ints.toArray(hashChannels));
            }
            this.parallelStreamMask = partitionFutures.size() - 1;
            this.partitions = new PagesIndex[partitionFutures.size()];
            for (int partition = 0; partition < this.partitions.length; ++partition) {
                this.partitions[partition] = new PagesIndex(types, expectedPositions);
            }
        }

        @Override
        public OperatorContext getOperatorContext() {
            return this.operatorContext;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public void finish() {
            if (this.finished) {
                return;
            }
            for (int partition = 0; partition < this.partitions.length; ++partition) {
                this.partitionFutures.get(partition).set((Object)this.partitions[partition]);
            }
            this.finished = true;
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }

        @Override
        public boolean needsInput() {
            return !this.finished;
        }

        @Override
        public void addInput(Page page) {
            Objects.requireNonNull(page, "page is null");
            Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
            BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus(), page.getPositionCount());
            for (int position = 0; position < page.getPositionCount(); ++position) {
                int rawHash = this.hashGenerator.hashPosition(position, page);
                int partition = HashCommon.murmurHash3((int)rawHash) & this.parallelStreamMask;
                BigintType.BIGINT.writeLong(blockBuilder, (long)partition);
            }
            Block partitionIds = blockBuilder.build();
            long size = 0L;
            for (int partition = 0; partition < this.partitions.length; ++partition) {
                PagesIndex index = this.partitions[partition];
                index.addPage(page, partition, partitionIds);
                size += index.getEstimatedSize().toBytes();
            }
            this.operatorContext.setMemoryReservation(size);
            this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
        }

        @Override
        public Page getOutput() {
            return null;
        }
    }

    private static class ParallelHashCollectOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<SettableFuture<PagesIndex>> partitionFutures;
        private final List<Type> types;
        private final List<Integer> hashChannels;
        private final Optional<Integer> hashChannel;
        private final int expectedPositions;
        private boolean closed;

        public ParallelHashCollectOperatorFactory(int operatorId, List<SettableFuture<PagesIndex>> partitionFutures, List<Type> types, List<Integer> hashChannels, Optional<Integer> hashChannel, int expectedPositions) {
            this.operatorId = operatorId;
            this.partitionFutures = partitionFutures;
            this.types = types;
            this.hashChannels = hashChannels;
            this.hashChannel = hashChannel;
            this.expectedPositions = expectedPositions;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, ParallelHashBuilder.class.getSimpleName());
            return new ParallelHashCollectOperator(operatorContext, this.partitionFutures, this.types, this.hashChannels, this.hashChannel, this.expectedPositions);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

