/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.Session;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.spi.Page;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class OperatorContext {
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private final int operatorId;
    private final String operatorType;
    private final DriverContext driverContext;
    private final Executor executor;
    private final AtomicLong intervalWallStart = new AtomicLong();
    private final AtomicLong intervalCpuStart = new AtomicLong();
    private final AtomicLong intervalUserStart = new AtomicLong();
    private final AtomicLong addInputCalls = new AtomicLong();
    private final AtomicLong addInputWallNanos = new AtomicLong();
    private final AtomicLong addInputCpuNanos = new AtomicLong();
    private final AtomicLong addInputUserNanos = new AtomicLong();
    private final CounterStat inputDataSize = new CounterStat();
    private final CounterStat inputPositions = new CounterStat();
    private final AtomicLong getOutputCalls = new AtomicLong();
    private final AtomicLong getOutputWallNanos = new AtomicLong();
    private final AtomicLong getOutputCpuNanos = new AtomicLong();
    private final AtomicLong getOutputUserNanos = new AtomicLong();
    private final CounterStat outputDataSize = new CounterStat();
    private final CounterStat outputPositions = new CounterStat();
    private final AtomicReference<SettableFuture<?>> memoryFuture = new AtomicReference();
    private final AtomicReference<BlockedMonitor> blockedMonitor = new AtomicReference();
    private final AtomicLong blockedWallNanos = new AtomicLong();
    private final AtomicLong finishCalls = new AtomicLong();
    private final AtomicLong finishWallNanos = new AtomicLong();
    private final AtomicLong finishCpuNanos = new AtomicLong();
    private final AtomicLong finishUserNanos = new AtomicLong();
    private final AtomicLong memoryReservation = new AtomicLong();
    private final AtomicLong systemMemoryReservation = new AtomicLong();
    private final long maxMemoryReservation;
    private final AtomicReference<Supplier<Object>> infoSupplier = new AtomicReference();
    private final boolean collectTimings;

    public OperatorContext(int operatorId, String operatorType, DriverContext driverContext, Executor executor, long maxMemoryReservation) {
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        this.operatorId = operatorId;
        this.maxMemoryReservation = maxMemoryReservation;
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.driverContext = Objects.requireNonNull(driverContext, "driverContext is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        SettableFuture future = SettableFuture.create();
        future.set(null);
        this.memoryFuture.set(future);
        this.collectTimings = driverContext.isVerboseStats() && driverContext.isCpuTimerEnabled();
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    public String getOperatorType() {
        return this.operatorType;
    }

    public DriverContext getDriverContext() {
        return this.driverContext;
    }

    public Session getSession() {
        return this.driverContext.getSession();
    }

    public boolean isDone() {
        return this.driverContext.isDone();
    }

    public void startIntervalTimer() {
        this.intervalWallStart.set(System.nanoTime());
        this.intervalCpuStart.set(this.currentThreadCpuTime());
        this.intervalUserStart.set(this.currentThreadUserTime());
    }

    public void recordAddInput(Page page) {
        this.addInputCalls.incrementAndGet();
        this.recordInputWallNanos(OperatorContext.nanosBetween(this.intervalWallStart.get(), System.nanoTime()));
        this.addInputCpuNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalCpuStart.get(), this.currentThreadCpuTime()));
        this.addInputUserNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalUserStart.get(), this.currentThreadUserTime()));
        if (page != null) {
            this.inputDataSize.update(page.getSizeInBytes());
            this.inputPositions.update((long)page.getPositionCount());
        }
    }

    public void recordGeneratedInput(long sizeInBytes, long positions) {
        this.recordGeneratedInput(sizeInBytes, positions, 0L);
    }

    public void recordGeneratedInput(long sizeInBytes, long positions, long readNanos) {
        this.inputDataSize.update(sizeInBytes);
        this.inputPositions.update(positions);
        this.recordInputWallNanos(readNanos);
    }

    public long recordInputWallNanos(long readNanos) {
        return this.addInputWallNanos.getAndAdd(readNanos);
    }

    public void recordGetOutput(Page page) {
        this.getOutputCalls.incrementAndGet();
        this.getOutputWallNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalWallStart.get(), System.nanoTime()));
        this.getOutputCpuNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalCpuStart.get(), this.currentThreadCpuTime()));
        this.getOutputUserNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalUserStart.get(), this.currentThreadUserTime()));
        if (page != null) {
            this.outputDataSize.update(page.getSizeInBytes());
            this.outputPositions.update((long)page.getPositionCount());
        }
    }

    public void recordGeneratedOutput(long sizeInBytes, long positions) {
        this.outputDataSize.update(sizeInBytes);
        this.outputPositions.update(positions);
    }

    public void recordBlocked(ListenableFuture<?> blocked) {
        Objects.requireNonNull(blocked, "blocked is null");
        BlockedMonitor monitor = new BlockedMonitor();
        BlockedMonitor oldMonitor = this.blockedMonitor.getAndSet(monitor);
        if (oldMonitor != null) {
            oldMonitor.run();
        }
        blocked.addListener((Runnable)monitor, this.executor);
    }

    public void recordFinish() {
        this.finishCalls.incrementAndGet();
        this.finishWallNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalWallStart.get(), System.nanoTime()));
        this.finishCpuNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalCpuStart.get(), this.currentThreadCpuTime()));
        this.finishUserNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalUserStart.get(), this.currentThreadUserTime()));
    }

    public ListenableFuture<?> isWaitingForMemory() {
        return (ListenableFuture)this.memoryFuture.get();
    }

    public DataSize getOperatorPreAllocatedMemory() {
        return this.driverContext.getOperatorPreAllocatedMemory();
    }

    public void reserveMemory(long bytes) {
        long newReservation;
        ListenableFuture<?> future = this.driverContext.reserveMemory(bytes);
        if (!future.isDone()) {
            SettableFuture<?> currentMemoryFuture = this.memoryFuture.get();
            while (currentMemoryFuture.isDone()) {
                SettableFuture<?> settableFuture = SettableFuture.create();
                if (this.memoryFuture.compareAndSet(currentMemoryFuture, settableFuture)) {
                    currentMemoryFuture = settableFuture;
                    continue;
                }
                currentMemoryFuture = this.memoryFuture.get();
            }
            final SettableFuture<?> finalMemoryFuture = currentMemoryFuture;
            Futures.addCallback(future, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    finalMemoryFuture.set(null);
                }

                public void onFailure(Throwable t) {
                    finalMemoryFuture.set(null);
                }
            });
        }
        if ((newReservation = this.memoryReservation.addAndGet(bytes)) > this.maxMemoryReservation) {
            this.memoryReservation.getAndAdd(-bytes);
            throw ExceededMemoryLimitException.exceededLocalLimit(new DataSize((double)this.maxMemoryReservation, DataSize.Unit.BYTE));
        }
    }

    public void reserveSystemMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        this.driverContext.reserveSystemMemory(bytes);
        this.systemMemoryReservation.addAndGet(bytes);
    }

    public boolean tryReserveMemory(long bytes) {
        if (!this.driverContext.tryReserveMemory(bytes)) {
            return false;
        }
        long newReservation = this.memoryReservation.addAndGet(bytes);
        if (newReservation > this.maxMemoryReservation) {
            this.memoryReservation.getAndAdd(-bytes);
            this.driverContext.freeMemory(bytes);
            return false;
        }
        return true;
    }

    public void freeMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((bytes <= this.memoryReservation.get() ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved");
        this.driverContext.freeMemory(bytes);
        this.memoryReservation.getAndAdd(-bytes);
    }

    public void freeSystemMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((bytes <= this.systemMemoryReservation.get() ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved");
        this.driverContext.freeSystemMemory(bytes);
        this.systemMemoryReservation.getAndAdd(-bytes);
    }

    public void moreMemoryAvailable() {
        this.memoryFuture.get().set(null);
    }

    public long transferMemoryToTaskContext() {
        long bytes = this.memoryReservation.getAndSet(0L);
        this.driverContext.transferMemoryToTaskContext(bytes);
        return bytes;
    }

    public void setMemoryReservation(long newMemoryReservation) {
        Preconditions.checkArgument((newMemoryReservation >= 0L ? 1 : 0) != 0, (Object)"newMemoryReservation is negative");
        long delta = newMemoryReservation - this.memoryReservation.get();
        if (delta > 0L) {
            this.reserveMemory(delta);
        } else {
            this.freeMemory(-delta);
        }
    }

    public boolean trySetMemoryReservation(long newMemoryReservation) {
        Preconditions.checkArgument((newMemoryReservation >= 0L ? 1 : 0) != 0, (Object)"newMemoryReservation is negative");
        long delta = newMemoryReservation - this.memoryReservation.get();
        if (delta > 0L) {
            return this.tryReserveMemory(delta);
        }
        this.freeMemory(-delta);
        return true;
    }

    public void setInfoSupplier(Supplier<Object> infoSupplier) {
        Objects.requireNonNull(infoSupplier, "infoProvider is null");
        this.infoSupplier.set(infoSupplier);
    }

    public CounterStat getInputDataSize() {
        return this.inputDataSize;
    }

    public CounterStat getInputPositions() {
        return this.inputPositions;
    }

    public CounterStat getOutputDataSize() {
        return this.outputDataSize;
    }

    public CounterStat getOutputPositions() {
        return this.outputPositions;
    }

    public OperatorStats getOperatorStats() {
        Supplier<Object> infoSupplier = this.infoSupplier.get();
        Object info = null;
        if (infoSupplier != null) {
            info = infoSupplier.get();
        }
        return new OperatorStats(this.operatorId, this.operatorType, this.addInputCalls.get(), new Duration((double)this.addInputWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.addInputCpuNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.addInputUserNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new DataSize((double)this.inputDataSize.getTotalCount(), DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), this.inputPositions.getTotalCount(), this.getOutputCalls.get(), new Duration((double)this.getOutputWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.getOutputCpuNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.getOutputUserNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new DataSize((double)this.outputDataSize.getTotalCount(), DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), this.outputPositions.getTotalCount(), new Duration((double)this.blockedWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), this.finishCalls.get(), new Duration((double)this.finishWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.finishCpuNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.finishUserNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new DataSize((double)this.memoryReservation.get(), DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), new DataSize((double)this.systemMemoryReservation.get(), DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), this.memoryFuture.get().isDone() ? Optional.empty() : Optional.of(BlockedReason.WAITING_FOR_MEMORY), info);
    }

    private long currentThreadUserTime() {
        if (!this.collectTimings) {
            return 0L;
        }
        return THREAD_MX_BEAN.getCurrentThreadUserTime();
    }

    private long currentThreadCpuTime() {
        if (!this.collectTimings) {
            return 0L;
        }
        return THREAD_MX_BEAN.getCurrentThreadCpuTime();
    }

    private static long nanosBetween(long start, long end) {
        return Math.abs(end - start);
    }

    private class BlockedMonitor
    implements Runnable {
        private final long start = System.nanoTime();
        private boolean finished;

        private BlockedMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            BlockedMonitor blockedMonitor = this;
            synchronized (blockedMonitor) {
                if (this.finished) {
                    return;
                }
                this.finished = true;
                OperatorContext.this.blockedMonitor.compareAndSet(this, null);
                OperatorContext.this.blockedWallNanos.getAndAdd(this.getBlockedTime());
            }
        }

        public long getBlockedTime() {
            return OperatorContext.nanosBetween(this.start, System.nanoTime());
        }
    }
}

