/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class DriverFactory
implements Closeable {
    private final boolean inputDriver;
    private final boolean outputDriver;
    private final List<OperatorFactory> operatorFactories;
    private final Set<PlanNodeId> sourceIds;
    private final int driverInstances;
    private boolean closed;

    public DriverFactory(boolean inputDriver, boolean outputDriver, OperatorFactory firstOperatorFactory, OperatorFactory ... otherOperatorFactories) {
        this(inputDriver, outputDriver, (List<OperatorFactory>)ImmutableList.builder().add((Object)Objects.requireNonNull(firstOperatorFactory, "firstOperatorFactory is null")).add((Object[])Objects.requireNonNull(otherOperatorFactories, "otherOperatorFactories is null")).build(), 1);
    }

    public DriverFactory(boolean inputDriver, boolean outputDriver, List<OperatorFactory> operatorFactories) {
        this(inputDriver, outputDriver, operatorFactories, 1);
    }

    public DriverFactory(boolean inputDriver, boolean outputDriver, List<OperatorFactory> operatorFactories, int driverInstances) {
        this.inputDriver = inputDriver;
        this.outputDriver = outputDriver;
        this.operatorFactories = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorFactories, "operatorFactories is null"));
        Preconditions.checkArgument((!operatorFactories.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one operator");
        this.driverInstances = driverInstances;
        ImmutableSet.Builder sourceIds = ImmutableSet.builder();
        for (OperatorFactory operatorFactory : operatorFactories) {
            if (!(operatorFactory instanceof SourceOperatorFactory)) continue;
            SourceOperatorFactory sourceOperatorFactory = (SourceOperatorFactory)operatorFactory;
            sourceIds.add((Object)sourceOperatorFactory.getSourceId());
        }
        this.sourceIds = sourceIds.build();
    }

    public boolean isInputDriver() {
        return this.inputDriver;
    }

    public boolean isOutputDriver() {
        return this.outputDriver;
    }

    public Set<PlanNodeId> getSourceIds() {
        return this.sourceIds;
    }

    public synchronized Driver createDriver(DriverContext driverContext) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"DriverFactory is already closed");
        Objects.requireNonNull(driverContext, "driverContext is null");
        ImmutableList.Builder operators = ImmutableList.builder();
        for (OperatorFactory operatorFactory : this.operatorFactories) {
            Operator operator = operatorFactory.createOperator(driverContext);
            operators.add((Object)operator);
        }
        return new Driver(driverContext, (List<Operator>)operators.build());
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            for (OperatorFactory operatorFactory : this.operatorFactories) {
                operatorFactory.close();
            }
        }
    }

    public int getDriverInstances() {
        return this.driverInstances;
    }
}

