/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.UnknownType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class ChannelSet {
    private final GroupByHash hash;
    private final boolean containsNull;

    public ChannelSet(GroupByHash hash, boolean containsNull) {
        this.hash = hash;
        this.containsNull = containsNull;
    }

    public Type getType() {
        return this.hash.getTypes().get(0);
    }

    public long getEstimatedSizeInBytes() {
        return this.hash.getEstimatedSize();
    }

    public int size() {
        return this.hash.getGroupCount();
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    public boolean contains(int position, Page page) {
        return this.hash.contains(position, page);
    }

    public static class ChannelSetBuilder {
        private final GroupByHash hash;
        private final OperatorContext operatorContext;
        private final Page nullBlockPage;

        public ChannelSetBuilder(Type type, Optional<Integer> hashChannel, int expectedPositions, OperatorContext operatorContext) {
            ImmutableList types = ImmutableList.of((Object)type);
            this.hash = GroupByHash.createGroupByHash((List<? extends Type>)types, new int[]{0}, Optional.empty(), hashChannel, expectedPositions);
            this.operatorContext = operatorContext;
            this.nullBlockPage = new Page(new Block[]{type.createBlockBuilder(new BlockBuilderStatus(), 1, UnknownType.UNKNOWN.getFixedSize()).appendNull().build()});
        }

        public ChannelSet build() {
            return new ChannelSet(this.hash, this.hash.contains(0, this.nullBlockPage));
        }

        public long getEstimatedSize() {
            return this.hash.getEstimatedSize();
        }

        public int size() {
            return this.hash.getGroupCount();
        }

        public void addPage(Page page) {
            this.hash.addPage(page);
            if (this.operatorContext != null) {
                this.operatorContext.setMemoryReservation(this.hash.getEstimatedSize());
            }
        }
    }
}

