/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.block.BlockUtils;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InternalTable {
    private final Map<String, Integer> columnIndexes;
    private final List<Page> pages;

    public InternalTable(Map<String, Integer> columnIndexes, Iterable<Page> pages) {
        this.columnIndexes = ImmutableMap.copyOf(Objects.requireNonNull(columnIndexes, "columnIndexes is null"));
        this.pages = ImmutableList.copyOf(Objects.requireNonNull(pages, "pages is null"));
    }

    public int getColumnIndex(String columnName) {
        Integer index = this.columnIndexes.get(columnName);
        Preconditions.checkArgument((index != null ? 1 : 0) != 0, (String)"Column %s not found", (Object[])new Object[]{columnName});
        return index;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public static Builder builder(ColumnMetadata ... columns) {
        return InternalTable.builder((List<ColumnMetadata>)ImmutableList.copyOf((Object[])columns));
    }

    public static Builder builder(List<ColumnMetadata> columns) {
        ImmutableList.Builder names = ImmutableList.builder();
        ImmutableList.Builder types = ImmutableList.builder();
        for (ColumnMetadata column : columns) {
            names.add((Object)column.getName());
            types.add((Object)column.getType());
        }
        return new Builder((List<String>)names.build(), (List<Type>)types.build());
    }

    public static class Builder {
        private final Map<String, Integer> columnIndexes;
        private final List<Type> types;
        private final List<Page> pages;
        private PageBuilder pageBuilder;

        public Builder(List<String> columnNames, List<Type> types) {
            Objects.requireNonNull(columnNames, "columnNames is null");
            ImmutableMap.Builder columnIndexes = ImmutableMap.builder();
            int columnIndex = 0;
            for (String columnName : columnNames) {
                columnIndexes.put((Object)columnName, (Object)columnIndex++);
            }
            this.columnIndexes = columnIndexes.build();
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            Preconditions.checkArgument((columnNames.size() == types.size() ? 1 : 0) != 0, (String)"Column name count does not match type count: columnNames=%s, types=%s", (Object[])new Object[]{columnNames, types.size()});
            this.pages = new ArrayList<Page>();
            this.pageBuilder = new PageBuilder(types);
        }

        public Builder add(Object ... values) {
            this.pageBuilder.declarePosition();
            for (int i = 0; i < this.types.size(); ++i) {
                BlockUtils.appendObject(this.types.get(i), this.pageBuilder.getBlockBuilder(i), values[i]);
            }
            if (this.pageBuilder.isFull()) {
                this.flushPage();
            }
            return this;
        }

        public InternalTable build() {
            this.flushPage();
            return new InternalTable(this.columnIndexes, this.pages);
        }

        private void flushPage() {
            if (!this.pageBuilder.isEmpty()) {
                this.pages.add(this.pageBuilder.build());
                this.pageBuilder.reset();
            }
        }
    }
}

