/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.PrestoNode;
import com.facebook.presto.spi.Node;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;

public class InMemoryNodeManager
implements InternalNodeManager {
    private final Node localNode;
    private final SetMultimap<String, Node> remoteNodes = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    @Inject
    public InMemoryNodeManager() {
        this(URI.create("local://127.0.0.1"));
    }

    public InMemoryNodeManager(URI localUri) {
        this.localNode = new PrestoNode("local", localUri, NodeVersion.UNKNOWN);
    }

    public void addCurrentNodeDatasource(String datasourceName) {
        this.addNode(datasourceName, this.localNode);
    }

    public void addNode(String datasourceName, Node ... nodes) {
        this.addNode(datasourceName, (Iterable<Node>)ImmutableList.copyOf((Object[])nodes));
    }

    public void addNode(String datasourceName, Iterable<Node> nodes) {
        this.remoteNodes.putAll((Object)datasourceName, nodes);
    }

    public Set<Node> getActiveNodes() {
        return this.getAllNodes().getActiveNodes();
    }

    public Set<Node> getActiveDatasourceNodes(String datasourceName) {
        return ImmutableSet.copyOf((Collection)this.remoteNodes.get((Object)datasourceName));
    }

    @Override
    public AllNodes getAllNodes() {
        return new AllNodes((Set<Node>)ImmutableSet.builder().add((Object)this.localNode).addAll((Iterable)this.remoteNodes.values()).build(), (Set<Node>)ImmutableSet.of());
    }

    public Node getCurrentNode() {
        return this.localNode;
    }

    public Set<Node> getCoordinators() {
        return ImmutableSet.of((Object)this.localNode);
    }

    @Override
    public void refreshNodes() {
    }
}

