/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.block.BlockSerdeUtil;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.metadata.FunctionType;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SpecializedFunctionKey;
import com.facebook.presto.operator.aggregation.ApproximateAverageAggregations;
import com.facebook.presto.operator.aggregation.ApproximateCountAggregation;
import com.facebook.presto.operator.aggregation.ApproximateCountColumnAggregations;
import com.facebook.presto.operator.aggregation.ApproximateCountDistinctAggregations;
import com.facebook.presto.operator.aggregation.ApproximateDoublePercentileAggregations;
import com.facebook.presto.operator.aggregation.ApproximateLongPercentileAggregations;
import com.facebook.presto.operator.aggregation.ApproximateLongPercentileArrayAggregations;
import com.facebook.presto.operator.aggregation.ApproximateSetAggregation;
import com.facebook.presto.operator.aggregation.ApproximateSumAggregations;
import com.facebook.presto.operator.aggregation.ArbitraryAggregation;
import com.facebook.presto.operator.aggregation.ArrayAggregation;
import com.facebook.presto.operator.aggregation.AverageAggregations;
import com.facebook.presto.operator.aggregation.BooleanAndAggregation;
import com.facebook.presto.operator.aggregation.BooleanOrAggregation;
import com.facebook.presto.operator.aggregation.ChecksumAggregation;
import com.facebook.presto.operator.aggregation.CorrelationAggregation;
import com.facebook.presto.operator.aggregation.CountAggregation;
import com.facebook.presto.operator.aggregation.CountColumn;
import com.facebook.presto.operator.aggregation.CountIfAggregation;
import com.facebook.presto.operator.aggregation.CovarianceAggregation;
import com.facebook.presto.operator.aggregation.DoubleSumAggregation;
import com.facebook.presto.operator.aggregation.GeometricMeanAggregations;
import com.facebook.presto.operator.aggregation.Histogram;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.LongSumAggregation;
import com.facebook.presto.operator.aggregation.MapAggregation;
import com.facebook.presto.operator.aggregation.MaxAggregation;
import com.facebook.presto.operator.aggregation.MaxBy;
import com.facebook.presto.operator.aggregation.MaxByNAggregation;
import com.facebook.presto.operator.aggregation.MaxNAggregation;
import com.facebook.presto.operator.aggregation.MergeHyperLogLogAggregation;
import com.facebook.presto.operator.aggregation.MinAggregation;
import com.facebook.presto.operator.aggregation.MinBy;
import com.facebook.presto.operator.aggregation.MinByNAggregation;
import com.facebook.presto.operator.aggregation.MinNAggregation;
import com.facebook.presto.operator.aggregation.MultimapAggregation;
import com.facebook.presto.operator.aggregation.NumericHistogramAggregation;
import com.facebook.presto.operator.aggregation.RegressionAggregation;
import com.facebook.presto.operator.aggregation.VarianceAggregation;
import com.facebook.presto.operator.scalar.ArrayCardinalityFunction;
import com.facebook.presto.operator.scalar.ArrayConcatFunction;
import com.facebook.presto.operator.scalar.ArrayConstructor;
import com.facebook.presto.operator.scalar.ArrayContains;
import com.facebook.presto.operator.scalar.ArrayDistinctFunction;
import com.facebook.presto.operator.scalar.ArrayElementAtFunction;
import com.facebook.presto.operator.scalar.ArrayEqualOperator;
import com.facebook.presto.operator.scalar.ArrayFunctions;
import com.facebook.presto.operator.scalar.ArrayGreaterThanOperator;
import com.facebook.presto.operator.scalar.ArrayGreaterThanOrEqualOperator;
import com.facebook.presto.operator.scalar.ArrayHashCodeOperator;
import com.facebook.presto.operator.scalar.ArrayIntersectFunction;
import com.facebook.presto.operator.scalar.ArrayJoin;
import com.facebook.presto.operator.scalar.ArrayLessThanOperator;
import com.facebook.presto.operator.scalar.ArrayLessThanOrEqualOperator;
import com.facebook.presto.operator.scalar.ArrayMaxFunction;
import com.facebook.presto.operator.scalar.ArrayMinFunction;
import com.facebook.presto.operator.scalar.ArrayNotEqualOperator;
import com.facebook.presto.operator.scalar.ArrayPositionFunction;
import com.facebook.presto.operator.scalar.ArrayRemoveFunction;
import com.facebook.presto.operator.scalar.ArraySliceFunction;
import com.facebook.presto.operator.scalar.ArraySortFunction;
import com.facebook.presto.operator.scalar.ArraySubscriptOperator;
import com.facebook.presto.operator.scalar.ArrayToArrayCast;
import com.facebook.presto.operator.scalar.ArrayToElementConcatFunction;
import com.facebook.presto.operator.scalar.ArrayToJsonCast;
import com.facebook.presto.operator.scalar.ColorFunctions;
import com.facebook.presto.operator.scalar.CombineHashFunction;
import com.facebook.presto.operator.scalar.ConcatFunction;
import com.facebook.presto.operator.scalar.DateTimeFunctions;
import com.facebook.presto.operator.scalar.ElementToArrayConcatFunction;
import com.facebook.presto.operator.scalar.FailureFunction;
import com.facebook.presto.operator.scalar.Greatest;
import com.facebook.presto.operator.scalar.HyperLogLogFunctions;
import com.facebook.presto.operator.scalar.IdentityCast;
import com.facebook.presto.operator.scalar.JsonFunctions;
import com.facebook.presto.operator.scalar.JsonOperators;
import com.facebook.presto.operator.scalar.JsonToArrayCast;
import com.facebook.presto.operator.scalar.JsonToMapCast;
import com.facebook.presto.operator.scalar.Least;
import com.facebook.presto.operator.scalar.MapCardinalityFunction;
import com.facebook.presto.operator.scalar.MapConstructor;
import com.facebook.presto.operator.scalar.MapEqualOperator;
import com.facebook.presto.operator.scalar.MapHashCodeOperator;
import com.facebook.presto.operator.scalar.MapKeys;
import com.facebook.presto.operator.scalar.MapNotEqualOperator;
import com.facebook.presto.operator.scalar.MapSubscriptOperator;
import com.facebook.presto.operator.scalar.MapToJsonCast;
import com.facebook.presto.operator.scalar.MapValues;
import com.facebook.presto.operator.scalar.MathFunctions;
import com.facebook.presto.operator.scalar.RegexpFunctions;
import com.facebook.presto.operator.scalar.RowEqualOperator;
import com.facebook.presto.operator.scalar.RowHashCodeOperator;
import com.facebook.presto.operator.scalar.RowNotEqualOperator;
import com.facebook.presto.operator.scalar.RowToJsonCast;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.StringFunctions;
import com.facebook.presto.operator.scalar.TryCastFunction;
import com.facebook.presto.operator.scalar.UrlFunctions;
import com.facebook.presto.operator.scalar.VarbinaryFunctions;
import com.facebook.presto.operator.window.CumulativeDistributionFunction;
import com.facebook.presto.operator.window.DenseRankFunction;
import com.facebook.presto.operator.window.FirstValueFunction;
import com.facebook.presto.operator.window.LagFunction;
import com.facebook.presto.operator.window.LastValueFunction;
import com.facebook.presto.operator.window.LeadFunction;
import com.facebook.presto.operator.window.NTileFunction;
import com.facebook.presto.operator.window.NthValueFunction;
import com.facebook.presto.operator.window.PercentRankFunction;
import com.facebook.presto.operator.window.RankFunction;
import com.facebook.presto.operator.window.RowNumberFunction;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.BigintOperators;
import com.facebook.presto.type.BooleanOperators;
import com.facebook.presto.type.ColorOperators;
import com.facebook.presto.type.DateOperators;
import com.facebook.presto.type.DateTimeOperators;
import com.facebook.presto.type.DoubleOperators;
import com.facebook.presto.type.HyperLogLogOperators;
import com.facebook.presto.type.IntervalDayTimeOperators;
import com.facebook.presto.type.IntervalYearMonthOperators;
import com.facebook.presto.type.JsonPathType;
import com.facebook.presto.type.LikeFunctions;
import com.facebook.presto.type.LikePatternType;
import com.facebook.presto.type.RegexpType;
import com.facebook.presto.type.RowParametricType;
import com.facebook.presto.type.RowType;
import com.facebook.presto.type.TimeOperators;
import com.facebook.presto.type.TimeWithTimeZoneOperators;
import com.facebook.presto.type.TimestampOperators;
import com.facebook.presto.type.TimestampWithTimeZoneOperators;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.type.UnknownOperators;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.type.VarbinaryOperators;
import com.facebook.presto.type.VarcharOperators;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.primitives.Primitives;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FunctionRegistry {
    private static final String MAGIC_LITERAL_FUNCTION_PREFIX = "$literal$";
    private static final String OPERATOR_PREFIX = "$operator$";
    private static final Set<Class<?>> SUPPORTED_LITERAL_TYPES = ImmutableSet.of(Long.TYPE, Double.TYPE, Slice.class, Boolean.TYPE);
    private final TypeManager typeManager;
    private final BlockEncodingSerde blockEncodingSerde;
    private final LoadingCache<SpecializedFunctionKey, FunctionInfo> specializedFunctionCache;
    private volatile FunctionMap functions = new FunctionMap();

    public FunctionRegistry(final TypeManager typeManager, BlockEncodingSerde blockEncodingSerde, boolean experimentalSyntaxEnabled) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.specializedFunctionCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<SpecializedFunctionKey, FunctionInfo>(){

            public FunctionInfo load(SpecializedFunctionKey key) throws Exception {
                return key.getFunction().specialize(key.getBoundTypeParameters(), key.getArity(), typeManager, FunctionRegistry.this);
            }
        });
        FunctionListBuilder builder = new FunctionListBuilder(typeManager).window("row_number", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of(), RowNumberFunction.class).window("rank", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of(), RankFunction.class).window("dense_rank", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of(), DenseRankFunction.class).window("percent_rank", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of(), PercentRankFunction.class).window("cume_dist", (Type)DoubleType.DOUBLE, (List<? extends Type>)ImmutableList.of(), CumulativeDistributionFunction.class).window("ntile", (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), NTileFunction.class).window("first_value", FirstValueFunction.class, "T", "T").window("last_value", LastValueFunction.class, "T", "T").window("nth_value", NthValueFunction.class, "T", "T", "bigint").window("lag", LagFunction.class, "T", "T").window("lag", LagFunction.class, "T", "T", "bigint").window("lag", LagFunction.class, "T", "T", "bigint", "T").window("lead", LeadFunction.class, "T", "T").window("lead", LeadFunction.class, "T", "T", "bigint").window("lead", LeadFunction.class, "T", "T", "bigint", "T").aggregate(CountAggregation.class).aggregate(VarianceAggregation.class).aggregate(ApproximateLongPercentileAggregations.class).aggregate(ApproximateLongPercentileArrayAggregations.class).aggregate(ApproximateDoublePercentileAggregations.class).aggregate(CountIfAggregation.class).aggregate(BooleanAndAggregation.class).aggregate(BooleanOrAggregation.class).aggregate(DoubleSumAggregation.class).aggregate(LongSumAggregation.class).aggregate(AverageAggregations.class).aggregate(GeometricMeanAggregations.class).aggregate(ApproximateCountDistinctAggregations.class).aggregate(MergeHyperLogLogAggregation.class).aggregate(ApproximateSetAggregation.class).aggregate(NumericHistogramAggregation.class).aggregate(CovarianceAggregation.class).aggregate(RegressionAggregation.class).aggregate(CorrelationAggregation.class).scalar(StringFunctions.class).scalar(VarbinaryFunctions.class).scalar(RegexpFunctions.class).scalar(UrlFunctions.class).scalar(MathFunctions.class).scalar(DateTimeFunctions.class).scalar(JsonFunctions.class).scalar(ColorFunctions.class).scalar(ColorOperators.class).scalar(HyperLogLogFunctions.class).scalar(UnknownOperators.class).scalar(BooleanOperators.class).scalar(BigintOperators.class).scalar(DoubleOperators.class).scalar(VarcharOperators.class).scalar(VarbinaryOperators.class).scalar(DateOperators.class).scalar(TimeOperators.class).scalar(TimestampOperators.class).scalar(IntervalDayTimeOperators.class).scalar(IntervalYearMonthOperators.class).scalar(TimeWithTimeZoneOperators.class).scalar(TimestampWithTimeZoneOperators.class).scalar(DateTimeOperators.class).scalar(HyperLogLogOperators.class).scalar(LikeFunctions.class).scalar(ArrayFunctions.class).scalar(CombineHashFunction.class).scalar(JsonOperators.class).scalar(FailureFunction.class).function(IdentityCast.IDENTITY_CAST).functions(ArrayContains.ARRAY_CONTAINS, ArrayJoin.ARRAY_JOIN, ArrayJoin.ARRAY_JOIN_WITH_NULL_REPLACEMENT).functions(ArrayMinFunction.ARRAY_MIN, ArrayMaxFunction.ARRAY_MAX).functions(ArrayToArrayCast.ARRAY_TO_ARRAY_CAST, ArrayHashCodeOperator.ARRAY_HASH_CODE, ArrayEqualOperator.ARRAY_EQUAL, ArrayNotEqualOperator.ARRAY_NOT_EQUAL, ArrayLessThanOperator.ARRAY_LESS_THAN, ArrayLessThanOrEqualOperator.ARRAY_LESS_THAN_OR_EQUAL, ArrayGreaterThanOperator.ARRAY_GREATER_THAN, ArrayGreaterThanOrEqualOperator.ARRAY_GREATER_THAN_OR_EQUAL).functions(ArrayConcatFunction.ARRAY_CONCAT_FUNCTION, ArrayToElementConcatFunction.ARRAY_TO_ELEMENT_CONCAT_FUNCTION, ElementToArrayConcatFunction.ELEMENT_TO_ARRAY_CONCAT_FUNCTION).functions(MapEqualOperator.MAP_EQUAL, MapNotEqualOperator.MAP_NOT_EQUAL, MapHashCodeOperator.MAP_HASH_CODE).functions(ArrayConstructor.ARRAY_CONSTRUCTOR, ArraySubscriptOperator.ARRAY_SUBSCRIPT, ArrayElementAtFunction.ARRAY_ELEMENT_AT_FUNCTION, ArrayCardinalityFunction.ARRAY_CARDINALITY, ArrayPositionFunction.ARRAY_POSITION, ArraySortFunction.ARRAY_SORT_FUNCTION, ArrayIntersectFunction.ARRAY_INTERSECT_FUNCTION, ArrayToJsonCast.ARRAY_TO_JSON, JsonToArrayCast.JSON_TO_ARRAY, ArrayDistinctFunction.ARRAY_DISTINCT_FUNCTION, ArrayRemoveFunction.ARRAY_REMOVE_FUNCTION, ArraySliceFunction.ARRAY_SLICE_FUNCTION).functions(MapConstructor.MAP_CONSTRUCTOR, MapCardinalityFunction.MAP_CARDINALITY, MapSubscriptOperator.MAP_SUBSCRIPT, MapToJsonCast.MAP_TO_JSON, JsonToMapCast.JSON_TO_MAP, MapKeys.MAP_KEYS, MapValues.MAP_VALUES).functions(MapAggregation.MAP_AGG, MultimapAggregation.MULTIMAP_AGG).function(Histogram.HISTOGRAM).function(ChecksumAggregation.CHECKSUM_AGGREGATION).function(ArbitraryAggregation.ARBITRARY_AGGREGATION).function(ArrayAggregation.ARRAY_AGGREGATION).functions(Greatest.GREATEST, Least.LEAST).functions(MaxBy.MAX_BY, MinBy.MIN_BY, MaxByNAggregation.MAX_BY_N_AGGREGATION, MinByNAggregation.MIN_BY_N_AGGREGATION).functions(MaxAggregation.MAX_AGGREGATION, MinAggregation.MIN_AGGREGATION, MaxNAggregation.MAX_N_AGGREGATION, MinNAggregation.MIN_N_AGGREGATION).function(CountColumn.COUNT_COLUMN).functions(RowHashCodeOperator.ROW_HASH_CODE, RowToJsonCast.ROW_TO_JSON, RowEqualOperator.ROW_EQUAL, RowNotEqualOperator.ROW_NOT_EQUAL).function(ConcatFunction.CONCAT).function(TryCastFunction.TRY_CAST);
        if (experimentalSyntaxEnabled) {
            builder.aggregate(ApproximateAverageAggregations.class).aggregate(ApproximateSumAggregations.class).aggregate(ApproximateCountAggregation.class).aggregate(ApproximateCountColumnAggregations.class);
        }
        this.addFunctions(builder.getFunctions());
    }

    @Nullable
    private static Signature bindSignature(Signature signature, List<? extends Type> types, boolean allowCoercion, TypeManager typeManager) {
        List<TypeSignature> argumentTypes = signature.getArgumentTypes();
        Map<String, Type> boundParameters = signature.bindTypeParameters(types, allowCoercion, typeManager);
        if (boundParameters == null) {
            return null;
        }
        ImmutableList.Builder boundArguments = ImmutableList.builder();
        for (int i = 0; i < argumentTypes.size() - 1; ++i) {
            boundArguments.add((Object)FunctionRegistry.bindParameters(argumentTypes.get(i), boundParameters));
        }
        if (!argumentTypes.isEmpty()) {
            TypeSignature lastArgument = FunctionRegistry.bindParameters(argumentTypes.get(argumentTypes.size() - 1), boundParameters);
            if (signature.isVariableArity()) {
                for (int i = 0; i < types.size() - (argumentTypes.size() - 1); ++i) {
                    boundArguments.add((Object)lastArgument);
                }
            } else {
                boundArguments.add((Object)lastArgument);
            }
        }
        return new Signature(signature.getName(), signature.getType(), FunctionRegistry.bindParameters(signature.getReturnType(), boundParameters), (List<TypeSignature>)boundArguments.build());
    }

    private static TypeSignature bindParameters(TypeSignature typeSignature, Map<String, Type> boundParameters) {
        List parameters = (List)typeSignature.getParameters().stream().map(signature -> FunctionRegistry.bindParameters(signature, boundParameters)).collect(ImmutableCollectors.toImmutableList());
        String base = typeSignature.getBase();
        if (boundParameters.containsKey(base)) {
            Verify.verify((typeSignature.getLiteralParameters().isEmpty() && typeSignature.getParameters().isEmpty() ? 1 : 0) != 0, (String)"Type parameters cannot have parameters", (Object[])new Object[0]);
            return boundParameters.get(base).getTypeSignature();
        }
        return new TypeSignature(base, parameters, typeSignature.getLiteralParameters());
    }

    public final synchronized void addFunctions(List<? extends ParametricFunction> functions) {
        for (ParametricFunction parametricFunction : functions) {
            for (ParametricFunction existingFunction : this.functions.list()) {
                Preconditions.checkArgument((!parametricFunction.getSignature().equals(existingFunction.getSignature()) ? 1 : 0) != 0, (String)"Function already registered: %s", (Object[])new Object[]{parametricFunction.getSignature()});
            }
        }
        this.functions = new FunctionMap(this.functions, functions);
    }

    public List<ParametricFunction> list() {
        return (List)this.functions.list().stream().filter(function -> !function.isHidden()).collect(ImmutableCollectors.toImmutableList());
    }

    public boolean isAggregationFunction(QualifiedName name) {
        return Iterables.any(this.functions.get(name), function -> function.getSignature().getType() == FunctionType.AGGREGATE || function.getSignature().getType() == FunctionType.APPROXIMATE_AGGREGATE);
    }

    public Signature resolveFunction(QualifiedName name, List<TypeSignature> parameterTypes, boolean approximate) {
        Signature signature;
        List candidates = (List)this.functions.get(name).stream().filter(function -> function.getSignature().getType() == FunctionType.SCALAR || function.getSignature().getType() == FunctionType.APPROXIMATE_AGGREGATE == approximate).collect(ImmutableCollectors.toImmutableList());
        List<Type> resolvedTypes = TypeUtils.resolveTypes(parameterTypes, this.typeManager);
        Signature match = null;
        for (Object function2 : candidates) {
            signature = FunctionRegistry.bindSignature(function2.getSignature(), resolvedTypes, false, this.typeManager);
            if (signature == null) continue;
            Preconditions.checkArgument((match == null ? 1 : 0) != 0, (String)"Ambiguous call to %s with parameters %s", (Object[])new Object[]{name, parameterTypes});
            match = signature;
        }
        if (match != null) {
            return match;
        }
        for (Object function2 : candidates) {
            signature = FunctionRegistry.bindSignature(function2.getSignature(), resolvedTypes, true, this.typeManager);
            if (signature == null) continue;
            return signature;
        }
        ArrayList<String> expectedParameters = new ArrayList<String>();
        for (ParametricFunction function3 : candidates) {
            expectedParameters.add(String.format("%s(%s) %s", name, Joiner.on((String)", ").join(function3.getSignature().getArgumentTypes()), Joiner.on((String)", ").join(function3.getSignature().getTypeParameters())));
        }
        String parameters = Joiner.on((String)", ").join(parameterTypes);
        String message = String.format("Function %s not registered", name);
        if (!expectedParameters.isEmpty()) {
            String expected = Joiner.on((String)", ").join(expectedParameters);
            message = String.format("Unexpected parameters (%s) for function %s. Expected: %s", parameters, name, expected);
        }
        if (name.getSuffix().startsWith(MAGIC_LITERAL_FUNCTION_PREFIX)) {
            String typeName = name.getSuffix().substring(MAGIC_LITERAL_FUNCTION_PREFIX.length());
            Type type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)typeName));
            Objects.requireNonNull(type, String.format("Type %s not registered", typeName));
            Preconditions.checkArgument((parameterTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected one argument to literal function, but got %s", (Object[])new Object[]{parameterTypes});
            Type parameterType = this.typeManager.getType(parameterTypes.get(0));
            Objects.requireNonNull(parameterType, String.format("Type %s not found", parameterTypes.get(0)));
            return FunctionRegistry.getMagicLiteralFunctionSignature(type);
        }
        FunctionInfo fieldReference = this.getRowFieldReferenceFunctionInfo(name, parameterTypes);
        if (fieldReference != null) {
            return fieldReference.getSignature();
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, message);
    }

    private FunctionInfo getRowFieldReferenceFunctionInfo(QualifiedName name, List<TypeSignature> parameterTypes) {
        List<Type> resolvedTypes = TypeUtils.resolveTypes(parameterTypes, this.typeManager);
        FunctionInfo match = null;
        for (TypeSignature typeSignature : parameterTypes) {
            if (!typeSignature.getBase().equals("row")) continue;
            RowType rowType = RowParametricType.ROW.createType(TypeUtils.resolveTypes(typeSignature.getParameters(), this.typeManager), (List<Object>)typeSignature.getLiteralParameters());
            for (ParametricFunction function : RowParametricType.ROW.createFunctions((Type)rowType)) {
                Map<String, Type> boundTypeParameters;
                if (!function.getSignature().getName().equals(name.toString()) || (boundTypeParameters = function.getSignature().bindTypeParameters(resolvedTypes, false, this.typeManager)) == null) continue;
                Preconditions.checkArgument((match == null ? 1 : 0) != 0, (String)"Ambiguous call to %s with parameters %s", (Object[])new Object[]{name, parameterTypes});
                try {
                    match = (FunctionInfo)this.specializedFunctionCache.getUnchecked((Object)new SpecializedFunctionKey(function, boundTypeParameters, resolvedTypes.size()));
                }
                catch (UncheckedExecutionException e) {
                    throw Throwables.propagate((Throwable)e.getCause());
                }
            }
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private FunctionInfo getExactFunction(Signature signature) {
        Collection<ParametricFunction> candidates = this.functions.get(QualifiedName.of((String)signature.getName(), (String[])new String[0]));
        for (ParametricFunction operator : candidates) {
            Type returnType = this.typeManager.getType(signature.getReturnType());
            List<Type> argumentTypes = TypeUtils.resolveTypes(signature.getArgumentTypes(), this.typeManager);
            Map<String, Type> boundTypeParameters = operator.getSignature().bindTypeParameters(returnType, argumentTypes, false, this.typeManager);
            if (boundTypeParameters == null) continue;
            try {
                return (FunctionInfo)this.specializedFunctionCache.getUnchecked((Object)new SpecializedFunctionKey(operator, boundTypeParameters, signature.getArgumentTypes().size()));
            }
            catch (UncheckedExecutionException e) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
        }
        return null;
    }

    public WindowFunctionSupplier getWindowFunctionImplementation(Signature signature) {
        Preconditions.checkArgument((signature.getType() == FunctionType.WINDOW || signature.getType() == FunctionType.AGGREGATE ? 1 : 0) != 0, (String)"%s is not a window function", (Object[])new Object[]{signature});
        Preconditions.checkArgument((boolean)signature.getTypeParameters().isEmpty(), (String)"%s has unbound type parameters", (Object[])new Object[]{signature});
        FunctionInfo function = this.getExactFunction(signature);
        Failures.checkCondition(function != null, (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, "%s not found", signature);
        return function.getWindowFunction();
    }

    public InternalAggregationFunction getAggregateFunctionImplementation(Signature signature) {
        Preconditions.checkArgument((signature.getType() == FunctionType.AGGREGATE || signature.getType() == FunctionType.APPROXIMATE_AGGREGATE ? 1 : 0) != 0, (String)"%s is not an aggregate function", (Object[])new Object[]{signature});
        Preconditions.checkArgument((boolean)signature.getTypeParameters().isEmpty(), (String)"%s has unbound type parameters", (Object[])new Object[]{signature});
        FunctionInfo function = this.getExactFunction(signature);
        Failures.checkCondition(function != null, (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, "%s not found", signature);
        return function.getAggregationFunction();
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(Signature signature) {
        Preconditions.checkArgument((signature.getType() == FunctionType.SCALAR ? 1 : 0) != 0, (String)"%s is not a scalar function", (Object[])new Object[]{signature});
        Preconditions.checkArgument((boolean)signature.getTypeParameters().isEmpty(), (String)"%s has unbound type parameters", (Object[])new Object[]{signature});
        FunctionInfo function = this.getExactFunction(signature);
        if (function == null && signature.getName().startsWith(MAGIC_LITERAL_FUNCTION_PREFIX)) {
            List<TypeSignature> parameterTypes = signature.getArgumentTypes();
            String typeName = signature.getName().substring(MAGIC_LITERAL_FUNCTION_PREFIX.length());
            Type type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)typeName));
            Objects.requireNonNull(type, String.format("Type %s not registered", typeName));
            Preconditions.checkArgument((parameterTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected one argument to literal function, but got %s", (Object[])new Object[]{parameterTypes});
            Type parameterType = this.typeManager.getType(parameterTypes.get(0));
            Objects.requireNonNull(parameterType, String.format("Type %s not found", parameterTypes.get(0)));
            MethodHandle methodHandle = null;
            if (parameterType.getJavaType() == type.getJavaType()) {
                methodHandle = MethodHandles.identity(parameterType.getJavaType());
            }
            if (parameterType.getJavaType() == Slice.class && type.getJavaType() == Block.class) {
                methodHandle = BlockSerdeUtil.READ_BLOCK.bindTo(this.blockEncodingSerde);
            }
            Preconditions.checkArgument((methodHandle != null ? 1 : 0) != 0, (String)"Expected type %s to use (or can be converted into) Java type %s, but Java type is %s", (Object[])new Object[]{type, parameterType.getJavaType(), type.getJavaType()});
            function = new FunctionInfo(signature, null, true, methodHandle, true, false, (List<Boolean>)ImmutableList.of((Object)false));
        }
        if (function == null) {
            function = this.getRowFieldReferenceFunctionInfo(QualifiedName.of((String)signature.getName(), (String[])new String[0]), signature.getArgumentTypes());
        }
        Failures.checkCondition(function != null, (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, "%s not found", signature);
        return new ScalarFunctionImplementation(function.isNullable(), function.getNullableArguments(), function.getMethodHandle(), function.isDeterministic());
    }

    @VisibleForTesting
    public List<ParametricFunction> listOperators() {
        Set operatorNames = (Set)Arrays.asList(OperatorType.values()).stream().map(FunctionRegistry::mangleOperatorName).collect(ImmutableCollectors.toImmutableSet());
        return (List)this.functions.list().stream().filter(function -> operatorNames.contains(function.getSignature().getName())).collect(ImmutableCollectors.toImmutableList());
    }

    public boolean canResolveOperator(OperatorType operatorType, Type returnType, List<? extends Type> argumentTypes) {
        return this.getExactFunction(Signature.internalOperator(operatorType, returnType, argumentTypes)) != null;
    }

    public Signature resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        try {
            return this.resolveFunction(QualifiedName.of((String)FunctionRegistry.mangleOperatorName(operatorType), (String[])new String[0]), Lists.transform(argumentTypes, Type::getTypeSignature), false);
        }
        catch (PrestoException e) {
            if (e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode().getCode()) {
                throw new OperatorNotFoundException(operatorType, argumentTypes);
            }
            throw e;
        }
    }

    public Signature getCoercion(Type fromType, Type toType) {
        FunctionInfo functionInfo = this.getExactFunction(Signature.internalOperator(OperatorType.CAST.name(), toType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)fromType.getTypeSignature())));
        if (functionInfo == null) {
            throw new OperatorNotFoundException(OperatorType.CAST, (List<? extends Type>)ImmutableList.of((Object)fromType), toType);
        }
        return functionInfo.getSignature();
    }

    public static boolean canCoerce(List<? extends Type> actualTypes, List<Type> expectedTypes) {
        if (actualTypes.size() != expectedTypes.size()) {
            return false;
        }
        for (int i = 0; i < expectedTypes.size(); ++i) {
            Type expectedType = expectedTypes.get(i);
            Type actualType = actualTypes.get(i);
            if (FunctionRegistry.canCoerce(actualType, expectedType)) continue;
            return false;
        }
        return true;
    }

    public static boolean canCoerce(Type actualType, Type expectedType) {
        if (expectedType.equals(actualType)) {
            return true;
        }
        if (actualType.equals((Object)UnknownType.UNKNOWN)) {
            return true;
        }
        if (actualType.equals(BigintType.BIGINT) && expectedType.equals(DoubleType.DOUBLE)) {
            return true;
        }
        if (actualType.equals(DateType.DATE) && expectedType.equals(TimestampType.TIMESTAMP)) {
            return true;
        }
        if (actualType.equals(DateType.DATE) && expectedType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            return true;
        }
        if (actualType.equals(TimeType.TIME) && expectedType.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
            return true;
        }
        if (actualType.equals(TimestampType.TIMESTAMP) && expectedType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            return true;
        }
        if (actualType.equals(VarcharType.VARCHAR) && expectedType.equals((Object)RegexpType.REGEXP)) {
            return true;
        }
        if (actualType.equals(VarcharType.VARCHAR) && expectedType.equals((Object)LikePatternType.LIKE_PATTERN)) {
            return true;
        }
        if (actualType.equals(VarcharType.VARCHAR) && expectedType.equals((Object)JsonPathType.JSON_PATH)) {
            return true;
        }
        if (actualType instanceof ArrayType && expectedType instanceof ArrayType) {
            Type actualElementType = ((ArrayType)actualType).getElementType();
            Type expectedElementType = ((ArrayType)expectedType).getElementType();
            return FunctionRegistry.canCoerce(actualElementType, expectedElementType);
        }
        return false;
    }

    public static Optional<Type> getCommonSuperType(List<? extends Type> types) {
        Preconditions.checkArgument((!types.isEmpty() ? 1 : 0) != 0, (Object)"types is empty");
        UnknownType superType = UnknownType.UNKNOWN;
        for (Type type : types) {
            Optional<Type> commonSuperType = FunctionRegistry.getCommonSuperType((Type)superType, type);
            if (!commonSuperType.isPresent()) {
                return Optional.empty();
            }
            superType = commonSuperType.get();
        }
        return Optional.of(superType);
    }

    public static Optional<Type> getCommonSuperType(Type firstType, Type secondType) {
        Optional<Type> elementType;
        if (firstType.equals((Object)UnknownType.UNKNOWN)) {
            return Optional.of(secondType);
        }
        if (secondType.equals((Object)UnknownType.UNKNOWN)) {
            return Optional.of(firstType);
        }
        if (firstType.equals(secondType)) {
            return Optional.of(firstType);
        }
        if ((firstType.equals(BigintType.BIGINT) || firstType.equals(DoubleType.DOUBLE)) && (secondType.equals(BigintType.BIGINT) || secondType.equals(DoubleType.DOUBLE))) {
            return Optional.of(DoubleType.DOUBLE);
        }
        if ((firstType.equals(DateType.DATE) || firstType.equals(TimestampType.TIMESTAMP)) && (secondType.equals(DateType.DATE) || secondType.equals(TimestampType.TIMESTAMP))) {
            return Optional.of(TimestampType.TIMESTAMP);
        }
        if ((firstType.equals(DateType.DATE) || firstType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) && (secondType.equals(DateType.DATE) || secondType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE))) {
            return Optional.of(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        }
        if ((firstType.equals(TimeType.TIME) || firstType.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) && (secondType.equals(TimeType.TIME) || secondType.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE))) {
            return Optional.of(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE);
        }
        if ((firstType.equals(TimestampType.TIMESTAMP) || firstType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) && (secondType.equals(TimestampType.TIMESTAMP) || secondType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE))) {
            return Optional.of(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        }
        if (firstType instanceof ArrayType && secondType instanceof ArrayType && (elementType = FunctionRegistry.getCommonSuperType(((ArrayType)firstType).getElementType(), ((ArrayType)secondType).getElementType())).isPresent()) {
            return Optional.of(new ArrayType(elementType.get()));
        }
        return Optional.empty();
    }

    public static Type typeForMagicLiteral(Type type) {
        Class clazz = type.getJavaType();
        if ((clazz = Primitives.unwrap((Class)clazz)) == Long.TYPE) {
            return BigintType.BIGINT;
        }
        if (clazz == Double.TYPE) {
            return DoubleType.DOUBLE;
        }
        if (!clazz.isPrimitive()) {
            if (type.equals(VarcharType.VARCHAR)) {
                return VarcharType.VARCHAR;
            }
            return VarbinaryType.VARBINARY;
        }
        if (clazz == Boolean.TYPE) {
            return BooleanType.BOOLEAN;
        }
        throw new IllegalArgumentException("Unhandled Java type: " + clazz.getName());
    }

    public static Signature getMagicLiteralFunctionSignature(Type type) {
        TypeSignature argumentType = FunctionRegistry.typeForMagicLiteral(type).getTypeSignature();
        return new Signature(MAGIC_LITERAL_FUNCTION_PREFIX + type.getTypeSignature(), FunctionType.SCALAR, type.getTypeSignature(), argumentType);
    }

    public static boolean isSupportedLiteralType(Type type) {
        return SUPPORTED_LITERAL_TYPES.contains(type.getJavaType());
    }

    public static FunctionInfo operatorInfo(OperatorType operatorType, TypeSignature returnType, List<TypeSignature> argumentTypes, MethodHandle method, boolean nullable, List<Boolean> nullableArguments) {
        operatorType.validateSignature(returnType, argumentTypes);
        Signature signature = Signature.internalOperator(operatorType.name(), returnType, argumentTypes);
        return new FunctionInfo(signature, operatorType.getOperator(), true, method, true, nullable, nullableArguments);
    }

    public static String mangleOperatorName(OperatorType operatorType) {
        return FunctionRegistry.mangleOperatorName(operatorType.name());
    }

    public static String mangleOperatorName(String operatorName) {
        return OPERATOR_PREFIX + operatorName;
    }

    @VisibleForTesting
    public static OperatorType unmangleOperator(String mangledName) {
        Preconditions.checkArgument((boolean)mangledName.startsWith(OPERATOR_PREFIX), (String)"%s is not a mangled operator name", (Object[])new Object[]{mangledName});
        return OperatorType.valueOf(mangledName.substring(OPERATOR_PREFIX.length()));
    }

    private static class FunctionMap {
        private final Multimap<QualifiedName, ParametricFunction> functions;

        public FunctionMap() {
            this.functions = ImmutableListMultimap.of();
        }

        public FunctionMap(FunctionMap map, Iterable<? extends ParametricFunction> functions) {
            this.functions = ImmutableListMultimap.builder().putAll(map.functions).putAll((Multimap)Multimaps.index(functions, function -> QualifiedName.of((String)function.getSignature().getName(), (String[])new String[0]))).build();
            for (Map.Entry entry : this.functions.asMap().entrySet()) {
                Collection values = (Collection)entry.getValue();
                long aggregations = values.stream().map(function -> function.getSignature().getType()).filter(type -> type == FunctionType.AGGREGATE || type == FunctionType.APPROXIMATE_AGGREGATE).count();
                Preconditions.checkState((aggregations == 0L || aggregations == (long)values.size() ? 1 : 0) != 0, (String)"'%s' is both an aggregation and a scalar function", (Object[])new Object[]{entry.getKey()});
            }
        }

        public List<ParametricFunction> list() {
            return ImmutableList.copyOf((Collection)this.functions.values());
        }

        public Collection<ParametricFunction> get(QualifiedName name) {
            return this.functions.get((Object)name);
        }
    }
}

