/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.window.AggregateWindowFunction;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Deprecated
public final class FunctionInfo
implements ParametricFunction {
    private final Signature signature;
    private final String description;
    private final boolean hidden;
    private final boolean nullable;
    private final List<Boolean> nullableArguments;
    private final TypeSignature intermediateType;
    private final InternalAggregationFunction aggregationFunction;
    private final MethodHandle methodHandle;
    private final boolean deterministic;
    private final WindowFunctionSupplier windowFunctionSupplier;

    public FunctionInfo(Signature signature, String description, WindowFunctionSupplier windowFunctionSupplier) {
        this.signature = signature;
        this.description = description;
        this.hidden = false;
        this.deterministic = true;
        this.nullable = false;
        this.nullableArguments = ImmutableList.copyOf(Collections.nCopies(signature.getArgumentTypes().size(), false));
        this.intermediateType = null;
        this.aggregationFunction = null;
        this.methodHandle = null;
        this.windowFunctionSupplier = Objects.requireNonNull(windowFunctionSupplier, "windowFunction is null");
    }

    public FunctionInfo(Signature signature, String description, InternalAggregationFunction function) {
        this.signature = signature;
        this.description = description;
        this.hidden = false;
        this.intermediateType = function.getIntermediateType().getTypeSignature();
        this.aggregationFunction = function;
        this.methodHandle = null;
        this.deterministic = true;
        this.nullable = false;
        this.nullableArguments = ImmutableList.copyOf(Collections.nCopies(signature.getArgumentTypes().size(), false));
        this.windowFunctionSupplier = AggregateWindowFunction.supplier(signature, function);
    }

    public FunctionInfo(Signature signature, String description, boolean hidden, MethodHandle function, boolean deterministic, boolean nullableResult, List<Boolean> nullableArguments) {
        this.signature = signature;
        this.description = description;
        this.hidden = hidden;
        this.deterministic = deterministic;
        this.nullable = nullableResult;
        this.nullableArguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(nullableArguments, "nullableArguments is null"));
        Preconditions.checkArgument((nullableArguments.size() == signature.getArgumentTypes().size() ? 1 : 0) != 0, (Object)String.format("nullableArguments size (%d) does not match signature %s", nullableArguments.size(), signature));
        this.intermediateType = null;
        this.aggregationFunction = null;
        this.windowFunctionSupplier = null;
        this.methodHandle = Objects.requireNonNull(function, "function is null");
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public TypeSignature getReturnType() {
        return this.signature.getReturnType();
    }

    public List<TypeSignature> getArgumentTypes() {
        return this.signature.getArgumentTypes();
    }

    public TypeSignature getIntermediateType() {
        return this.intermediateType;
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        return this;
    }

    @Deprecated
    public WindowFunctionSupplier getWindowFunction() {
        Preconditions.checkState((this.windowFunctionSupplier != null ? 1 : 0) != 0, (Object)"not a window function");
        return this.windowFunctionSupplier;
    }

    @Deprecated
    public InternalAggregationFunction getAggregationFunction() {
        Preconditions.checkState((this.aggregationFunction != null ? 1 : 0) != 0, (Object)"not an aggregation function");
        return this.aggregationFunction;
    }

    @Deprecated
    public MethodHandle getMethodHandle() {
        Preconditions.checkState((this.methodHandle != null ? 1 : 0) != 0, (Object)"not a scalar function or operator");
        return this.methodHandle;
    }

    @Override
    public boolean isDeterministic() {
        return this.deterministic;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public List<Boolean> getNullableArguments() {
        return this.nullableArguments;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionInfo other = (FunctionInfo)obj;
        return Objects.equals(this.signature, other.signature);
    }

    public int hashCode() {
        return Objects.hash(this.signature);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("signature", (Object)this.signature).toString();
    }
}

