/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.failureDetector.FailureDetector;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.PrestoNode;
import com.facebook.presto.spi.Node;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceType;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public final class DiscoveryNodeManager
implements InternalNodeManager {
    private static final Duration MAX_AGE = new Duration(5.0, TimeUnit.SECONDS);
    private static final Splitter DATASOURCES_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final ServiceSelector serviceSelector;
    private final NodeInfo nodeInfo;
    private final FailureDetector failureDetector;
    private final NodeVersion expectedNodeVersion;
    @GuardedBy(value="this")
    private SetMultimap<String, Node> activeNodesByDataSource;
    @GuardedBy(value="this")
    private AllNodes allNodes;
    @GuardedBy(value="this")
    private long lastUpdateTimestamp;
    private final PrestoNode currentNode;
    @GuardedBy(value="this")
    private Set<Node> coordinators;

    @Inject
    public DiscoveryNodeManager(@ServiceType(value="presto") ServiceSelector serviceSelector, NodeInfo nodeInfo, FailureDetector failureDetector, NodeVersion expectedNodeVersion) {
        this.serviceSelector = Objects.requireNonNull(serviceSelector, "serviceSelector is null");
        this.nodeInfo = Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        this.failureDetector = Objects.requireNonNull(failureDetector, "failureDetector is null");
        this.expectedNodeVersion = Objects.requireNonNull(expectedNodeVersion, "expectedNodeVersion is null");
        this.currentNode = this.refreshNodesInternal();
    }

    @Override
    public void refreshNodes() {
        this.refreshNodesInternal();
    }

    private synchronized PrestoNode refreshNodesInternal() {
        this.lastUpdateTimestamp = System.nanoTime();
        Set services = (Set)this.serviceSelector.selectAllServices().stream().filter(service -> !this.failureDetector.getFailed().contains(service)).collect(ImmutableCollectors.toImmutableSet());
        PrestoNode currentNode = null;
        ImmutableSet.Builder activeNodesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder inactiveNodesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder coordinatorsBuilder = ImmutableSet.builder();
        ImmutableSetMultimap.Builder byDataSourceBuilder = ImmutableSetMultimap.builder();
        for (ServiceDescriptor service2 : services) {
            URI uri = DiscoveryNodeManager.getHttpUri(service2);
            NodeVersion nodeVersion = DiscoveryNodeManager.getNodeVersion(service2);
            if (uri == null || nodeVersion == null) continue;
            PrestoNode node = new PrestoNode(service2.getNodeId(), uri, nodeVersion);
            if (node.getNodeIdentifier().equals(this.nodeInfo.getNodeId())) {
                currentNode = node;
                Preconditions.checkState((boolean)currentNode.getNodeVersion().equals((Object)this.expectedNodeVersion), (Object)"INVARIANT: current node version should be equal to expected node version");
            }
            if (this.isActive(node)) {
                String dataSources;
                activeNodesBuilder.add((Object)node);
                if (Boolean.parseBoolean((String)service2.getProperties().get("coordinator"))) {
                    coordinatorsBuilder.add((Object)node);
                }
                if ((dataSources = (String)service2.getProperties().get("datasources")) != null) {
                    dataSources = dataSources.toLowerCase(Locale.ENGLISH);
                    for (String dataSource : DATASOURCES_SPLITTER.split((CharSequence)dataSources)) {
                        byDataSourceBuilder.put((Object)dataSource, (Object)node);
                    }
                }
                byDataSourceBuilder.put((Object)"system", (Object)node);
                continue;
            }
            inactiveNodesBuilder.add((Object)node);
        }
        this.allNodes = new AllNodes((Set<Node>)activeNodesBuilder.build(), (Set<Node>)inactiveNodesBuilder.build());
        this.activeNodesByDataSource = byDataSourceBuilder.build();
        this.coordinators = coordinatorsBuilder.build();
        Preconditions.checkState((currentNode != null ? 1 : 0) != 0, (Object)"INVARIANT: current node not returned from service selector");
        return currentNode;
    }

    private synchronized void refreshIfNecessary() {
        if (Duration.nanosSince((long)this.lastUpdateTimestamp).compareTo(MAX_AGE) > 0) {
            this.refreshNodesInternal();
        }
    }

    private boolean isActive(PrestoNode node) {
        return this.expectedNodeVersion.equals((Object)node.getNodeVersion());
    }

    @Override
    public synchronized AllNodes getAllNodes() {
        this.refreshIfNecessary();
        return this.allNodes;
    }

    public Set<Node> getActiveNodes() {
        return this.getAllNodes().getActiveNodes();
    }

    public synchronized Set<Node> getActiveDatasourceNodes(String datasourceName) {
        this.refreshIfNecessary();
        return this.activeNodesByDataSource.get((Object)datasourceName);
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public synchronized Set<Node> getCoordinators() {
        this.refreshIfNecessary();
        return this.coordinators;
    }

    private static URI getHttpUri(ServiceDescriptor descriptor) {
        for (String type : Arrays.asList("http", "https")) {
            String url = (String)descriptor.getProperties().get(type);
            if (url == null) continue;
            try {
                return new URI(url);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
        }
        return null;
    }

    private static NodeVersion getNodeVersion(ServiceDescriptor descriptor) {
        String nodeVersion = (String)descriptor.getProperties().get("node_version");
        return nodeVersion == null ? null : new NodeVersion(nodeVersion);
    }
}

