/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.NodeScheduler;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.scheduler.ScheduleResult;
import com.facebook.presto.execution.scheduler.StageScheduler;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class FixedCountScheduler
implements StageScheduler {
    private final Function<Node, RemoteTask> taskScheduler;
    private final Function<Integer, List<Node>> randomNodeSupplier;
    private final int nodeCount;

    public FixedCountScheduler(SqlStageExecution stage, NodeScheduler.NodeSelector nodeSelector, int nodeCount) {
        this(Objects.requireNonNull(stage, "stage is null")::scheduleTask, Objects.requireNonNull(nodeSelector, "nodeSelector is null")::selectRandomNodes, nodeCount);
    }

    @VisibleForTesting
    FixedCountScheduler(Function<Node, RemoteTask> taskScheduler, Function<Integer, List<Node>> randomNodeSupplier, int nodeCount) {
        this.taskScheduler = Objects.requireNonNull(taskScheduler, "taskScheduler is null");
        this.randomNodeSupplier = Objects.requireNonNull(randomNodeSupplier, "randomNodeSupplier is null");
        Preconditions.checkArgument((nodeCount > 0 ? 1 : 0) != 0, (Object)"nodeCount must be at least one");
        this.nodeCount = nodeCount;
    }

    @Override
    public ScheduleResult schedule() {
        List<Node> nodes = this.randomNodeSupplier.apply(this.nodeCount);
        Failures.checkCondition(!nodes.isEmpty(), (ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No worker nodes available", new Object[0]);
        List newTasks = (List)nodes.stream().map(this.taskScheduler::apply).collect(ImmutableCollectors.toImmutableList());
        return new ScheduleResult(true, newTasks, CompletableFuture.completedFuture(null));
    }
}

