/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.Session;
import com.facebook.presto.TaskSource;
import com.facebook.presto.execution.BufferResult;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.execution.SqlTaskExecution;
import com.facebook.presto.execution.SqlTaskExecutionFactory;
import com.facebook.presto.execution.SqlTaskIoStats;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.SystemMemoryUsageListener;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.util.Failures;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.SetThreadName;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class SqlTask {
    private static final Logger log = Logger.get(SqlTask.class);
    private final TaskId taskId;
    private final String nodeInstanceId;
    private final URI location;
    private final TaskStateMachine taskStateMachine;
    private final SharedBuffer sharedBuffer;
    private final QueryContext queryContext;
    private final SqlTaskExecutionFactory sqlTaskExecutionFactory;
    private final AtomicReference<DateTime> lastHeartbeat = new AtomicReference<DateTime>(DateTime.now());
    private final AtomicLong nextTaskInfoVersion = new AtomicLong(1L);
    private final AtomicReference<TaskHolder> taskHolderReference = new AtomicReference<TaskHolder>(new TaskHolder());

    public SqlTask(TaskId taskId, String nodeInstanceId, URI location, QueryContext queryContext, SqlTaskExecutionFactory sqlTaskExecutionFactory, ExecutorService taskNotificationExecutor, final Function<SqlTask, ?> onDone, DataSize maxBufferSize) {
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.nodeInstanceId = Objects.requireNonNull(nodeInstanceId, "nodeInstanceId is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.queryContext = Objects.requireNonNull(queryContext, "queryContext is null");
        this.sqlTaskExecutionFactory = Objects.requireNonNull(sqlTaskExecutionFactory, "sqlTaskExecutionFactory is null");
        Objects.requireNonNull(taskNotificationExecutor, "taskNotificationExecutor is null");
        Objects.requireNonNull(onDone, "onDone is null");
        Objects.requireNonNull(maxBufferSize, "maxBufferSize is null");
        this.sharedBuffer = new SharedBuffer(taskId, taskNotificationExecutor, maxBufferSize, new UpdateSystemMemory(queryContext));
        this.taskStateMachine = new TaskStateMachine(taskId, taskNotificationExecutor);
        this.taskStateMachine.addStateChangeListener(new StateMachine.StateChangeListener<TaskState>(){

            @Override
            public void stateChanged(TaskState newState) {
                TaskHolder taskHolder;
                if (!newState.isDone()) {
                    return;
                }
                do {
                    if (!(taskHolder = (TaskHolder)SqlTask.this.taskHolderReference.get()).isFinished()) continue;
                    return;
                } while (!SqlTask.this.taskHolderReference.compareAndSet(taskHolder, new TaskHolder(SqlTask.this.createTaskInfo(taskHolder), taskHolder.getIoStats())));
                if (newState == TaskState.FAILED || newState == TaskState.ABORTED) {
                    SqlTask.this.sharedBuffer.fail();
                } else {
                    SqlTask.this.sharedBuffer.destroy();
                }
                try {
                    onDone.apply((Object)SqlTask.this);
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "Error running task cleanup callback %s", new Object[]{SqlTask.this.taskId});
                }
            }
        });
    }

    public SqlTaskIoStats getIoStats() {
        return this.taskHolderReference.get().getIoStats();
    }

    public TaskId getTaskId() {
        return this.taskStateMachine.getTaskId();
    }

    public void recordHeartbeat() {
        this.lastHeartbeat.set(DateTime.now());
    }

    public TaskInfo getTaskInfo() {
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            TaskInfo taskInfo = this.createTaskInfo(this.taskHolderReference.get());
            return taskInfo;
        }
    }

    private TaskInfo createTaskInfo(TaskHolder taskHolder) {
        ImmutableSet noMoreSplits;
        TaskStats taskStats;
        TaskInfo finalTaskInfo;
        long versionNumber = this.nextTaskInfoVersion.getAndIncrement();
        TaskState state = this.taskStateMachine.getState();
        Object failures = ImmutableList.of();
        if (state == TaskState.FAILED) {
            failures = Failures.toFailures(this.taskStateMachine.getFailureCauses());
        }
        if ((finalTaskInfo = taskHolder.getFinalTaskInfo()) != null) {
            taskStats = finalTaskInfo.getStats();
            noMoreSplits = finalTaskInfo.getNoMoreSplits();
        } else {
            SqlTaskExecution taskExecution = taskHolder.getTaskExecution();
            if (taskExecution != null) {
                taskStats = taskExecution.getTaskContext().getTaskStats();
                noMoreSplits = taskExecution.getNoMoreSplits();
            } else {
                DateTime endTime = state.isDone() ? DateTime.now() : null;
                taskStats = new TaskStats(this.taskStateMachine.getCreatedTime(), endTime);
                noMoreSplits = ImmutableSet.of();
            }
        }
        return new TaskInfo(this.taskStateMachine.getTaskId(), Optional.of(this.nodeInstanceId), versionNumber, state, this.location, this.lastHeartbeat.get(), this.sharedBuffer.getInfo(), (Set<PlanNodeId>)noMoreSplits, taskStats, (List<ExecutionFailureInfo>)failures);
    }

    public CompletableFuture<TaskInfo> getTaskInfo(TaskState callersCurrentState) {
        Objects.requireNonNull(callersCurrentState, "callersCurrentState is null");
        if (callersCurrentState.isDone()) {
            return CompletableFuture.completedFuture(this.getTaskInfo());
        }
        CompletableFuture<TaskState> futureTaskState = this.taskStateMachine.getStateChange(callersCurrentState);
        return futureTaskState.thenApply(input -> this.getTaskInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInfo updateTask(Session session, PlanFragment fragment, List<TaskSource> sources, OutputBuffers outputBuffers) {
        try {
            SqlTaskExecution taskExecution;
            SqlTask sqlTask = this;
            synchronized (sqlTask) {
                TaskHolder taskHolder = this.taskHolderReference.get();
                if (taskHolder.isFinished()) {
                    return taskHolder.getFinalTaskInfo();
                }
                taskExecution = taskHolder.getTaskExecution();
                if (taskExecution == null) {
                    taskExecution = this.sqlTaskExecutionFactory.create(session, this.queryContext, this.taskStateMachine, this.sharedBuffer, fragment, sources);
                    this.taskHolderReference.compareAndSet(taskHolder, new TaskHolder(taskExecution));
                }
            }
            if (taskExecution != null) {
                this.sharedBuffer.setOutputBuffers(outputBuffers);
                taskExecution.addSources(sources);
            }
        }
        catch (Error e) {
            this.failed(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.failed(e);
        }
        return this.getTaskInfo();
    }

    public CompletableFuture<BufferResult> getTaskResults(TaskId outputName, long startingSequenceId, DataSize maxSize) {
        Objects.requireNonNull(outputName, "outputName is null");
        Preconditions.checkArgument((maxSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxSize must be at least 1 byte");
        return this.sharedBuffer.get(outputName, startingSequenceId, maxSize);
    }

    public TaskInfo abortTaskResults(TaskId outputId) {
        Objects.requireNonNull(outputId, "outputId is null");
        log.debug("Aborting task %s output %s", new Object[]{this.taskId, outputId});
        this.sharedBuffer.abort(outputId);
        return this.getTaskInfo();
    }

    public void failed(Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.taskStateMachine.failed(cause);
    }

    public TaskInfo cancel() {
        this.taskStateMachine.cancel();
        return this.getTaskInfo();
    }

    public TaskInfo abort() {
        this.taskStateMachine.abort();
        return this.getTaskInfo();
    }

    public String toString() {
        return this.taskId.toString();
    }

    private static final class TaskHolder {
        private final SqlTaskExecution taskExecution;
        private final TaskInfo finalTaskInfo;
        private final SqlTaskIoStats finalIoStats;

        private TaskHolder() {
            this.taskExecution = null;
            this.finalTaskInfo = null;
            this.finalIoStats = null;
        }

        private TaskHolder(SqlTaskExecution taskExecution) {
            this.taskExecution = Objects.requireNonNull(taskExecution, "taskExecution is null");
            this.finalTaskInfo = null;
            this.finalIoStats = null;
        }

        private TaskHolder(TaskInfo finalTaskInfo, SqlTaskIoStats finalIoStats) {
            this.taskExecution = null;
            this.finalTaskInfo = Objects.requireNonNull(finalTaskInfo, "finalTaskInfo is null");
            this.finalIoStats = Objects.requireNonNull(finalIoStats, "finalIoStats is null");
        }

        public boolean isFinished() {
            return this.finalTaskInfo != null;
        }

        @Nullable
        public SqlTaskExecution getTaskExecution() {
            return this.taskExecution;
        }

        @Nullable
        public TaskInfo getFinalTaskInfo() {
            return this.finalTaskInfo;
        }

        public SqlTaskIoStats getIoStats() {
            if (this.finalIoStats != null) {
                return this.finalIoStats;
            }
            if (this.taskExecution == null) {
                return new SqlTaskIoStats();
            }
            TaskContext taskContext = this.taskExecution.getTaskContext();
            return new SqlTaskIoStats(taskContext.getInputDataSize(), taskContext.getInputPositions(), taskContext.getOutputDataSize(), taskContext.getOutputPositions());
        }
    }

    private static final class UpdateSystemMemory
    implements SystemMemoryUsageListener {
        private final QueryContext queryContext;

        public UpdateSystemMemory(QueryContext queryContext) {
            this.queryContext = Objects.requireNonNull(queryContext, "queryContext is null");
        }

        @Override
        public void updateSystemMemoryUsage(long deltaMemoryInBytes) {
            if (deltaMemoryInBytes > 0L) {
                this.queryContext.reserveSystemMemory(deltaMemoryInBytes);
            } else {
                this.queryContext.freeSystemMemory(-deltaMemoryInBytes);
            }
        }
    }
}

