/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class InformationSchemaTableHandle
implements ConnectorTableHandle {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;

    @JsonCreator
    public InformationSchemaTableHandle(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    @JsonProperty
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public String toString() {
        return "information_schema:" + this.catalogName + ":" + this.schemaName + ":" + this.tableName;
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InformationSchemaTableHandle other = (InformationSchemaTableHandle)obj;
        return Objects.equals(this.catalogName, other.catalogName) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }
}

