/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class NewInstanceByteCodeExpression
extends ByteCodeExpression {
    private final List<ByteCodeExpression> parameters;
    private final ImmutableList<ParameterizedType> parameterTypes;

    public NewInstanceByteCodeExpression(ParameterizedType type, Iterable<ParameterizedType> parameterTypes, Iterable<? extends ByteCodeExpression> parameters) {
        super(type);
        this.parameterTypes = ImmutableList.copyOf(Objects.requireNonNull(parameterTypes, "parameterTypes is null"));
        this.parameters = ImmutableList.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        ByteCodeBlock block = new ByteCodeBlock().newObject(this.getType()).dup();
        for (ByteCodeExpression parameter : this.parameters) {
            block.append(parameter);
        }
        return block.invokeConstructor(this.getType(), (Iterable<ParameterizedType>)this.parameterTypes);
    }

    @Override
    protected String formatOneLine() {
        return "new " + this.getType().getSimpleName() + "(" + Joiner.on((String)", ").join(this.parameters) + ")";
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.copyOf(this.parameters);
    }
}

