/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode;

import com.facebook.presto.byteCode.AnnotationDefinition;
import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.Comment;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.control.DoWhileLoop;
import com.facebook.presto.byteCode.control.FlowControl;
import com.facebook.presto.byteCode.control.ForLoop;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.control.LookupSwitch;
import com.facebook.presto.byteCode.control.TryCatch;
import com.facebook.presto.byteCode.control.WhileLoop;
import com.facebook.presto.byteCode.debug.DebugNode;
import com.facebook.presto.byteCode.debug.LineNumberNode;
import com.facebook.presto.byteCode.debug.LocalVariableNode;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.instruction.Constant;
import com.facebook.presto.byteCode.instruction.FieldInstruction;
import com.facebook.presto.byteCode.instruction.InstructionNode;
import com.facebook.presto.byteCode.instruction.InvokeInstruction;
import com.facebook.presto.byteCode.instruction.JumpInstruction;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.byteCode.instruction.VariableInstruction;

public class ByteCodeVisitor<T> {
    public T visitClass(ClassDefinition classDefinition) {
        for (AnnotationDefinition annotationDefinition : classDefinition.getAnnotations()) {
            this.visitAnnotation(classDefinition, annotationDefinition);
        }
        for (FieldDefinition fieldDefinition : classDefinition.getFields()) {
            this.visitField(classDefinition, fieldDefinition);
        }
        for (MethodDefinition methodDefinition : classDefinition.getMethods()) {
            this.visitMethod(classDefinition, methodDefinition);
        }
        return null;
    }

    public T visitAnnotation(Object parent, AnnotationDefinition annotationDefinition) {
        return null;
    }

    public T visitField(ClassDefinition classDefinition, FieldDefinition fieldDefinition) {
        for (AnnotationDefinition annotationDefinition : fieldDefinition.getAnnotations()) {
            this.visitAnnotation(fieldDefinition, annotationDefinition);
        }
        return null;
    }

    public T visitMethod(ClassDefinition classDefinition, MethodDefinition methodDefinition) {
        for (AnnotationDefinition annotationDefinition : methodDefinition.getAnnotations()) {
            this.visitAnnotation(methodDefinition, annotationDefinition);
        }
        methodDefinition.getBody().accept(null, this);
        return null;
    }

    public T visitNode(ByteCodeNode parent, ByteCodeNode node) {
        for (ByteCodeNode byteCodeNode : node.getChildNodes()) {
            byteCodeNode.accept(node, this);
        }
        return null;
    }

    public T visitComment(ByteCodeNode parent, Comment node) {
        return this.visitNode(parent, node);
    }

    public T visitBlock(ByteCodeNode parent, ByteCodeBlock block) {
        return this.visitNode(parent, block);
    }

    public T visitByteCodeExpression(ByteCodeNode parent, ByteCodeExpression byteCodeExpression) {
        return this.visitNode(parent, byteCodeExpression);
    }

    public T visitFlowControl(ByteCodeNode parent, FlowControl flowControl) {
        return this.visitNode(parent, flowControl);
    }

    public T visitTryCatch(ByteCodeNode parent, TryCatch tryCatch) {
        return this.visitFlowControl(parent, tryCatch);
    }

    public T visitIf(ByteCodeNode parent, IfStatement ifStatement) {
        return this.visitFlowControl(parent, ifStatement);
    }

    public T visitFor(ByteCodeNode parent, ForLoop forLoop) {
        return this.visitFlowControl(parent, forLoop);
    }

    public T visitWhile(ByteCodeNode parent, WhileLoop whileLoop) {
        return this.visitFlowControl(parent, whileLoop);
    }

    public T visitDoWhile(ByteCodeNode parent, DoWhileLoop doWhileLoop) {
        return this.visitFlowControl(parent, doWhileLoop);
    }

    public T visitLookupSwitch(ByteCodeNode parent, LookupSwitch lookupSwitch) {
        return this.visitFlowControl(parent, lookupSwitch);
    }

    public T visitInstruction(ByteCodeNode parent, InstructionNode node) {
        return this.visitNode(parent, node);
    }

    public T visitLabel(ByteCodeNode parent, LabelNode labelNode) {
        return this.visitInstruction(parent, labelNode);
    }

    public T visitJumpInstruction(ByteCodeNode parent, JumpInstruction jumpInstruction) {
        return this.visitInstruction(parent, jumpInstruction);
    }

    public T visitConstant(ByteCodeNode parent, Constant constant) {
        return this.visitInstruction(parent, constant);
    }

    public T visitBoxedBooleanConstant(ByteCodeNode parent, Constant.BoxedBooleanConstant boxedBooleanConstant) {
        return this.visitConstant(parent, boxedBooleanConstant);
    }

    public T visitBooleanConstant(ByteCodeNode parent, Constant.BooleanConstant booleanConstant) {
        return this.visitConstant(parent, booleanConstant);
    }

    public T visitIntConstant(ByteCodeNode parent, Constant.IntConstant intConstant) {
        return this.visitConstant(parent, intConstant);
    }

    public T visitBoxedIntegerConstant(ByteCodeNode parent, Constant.BoxedIntegerConstant boxedIntegerConstant) {
        return this.visitConstant(parent, boxedIntegerConstant);
    }

    public T visitFloatConstant(ByteCodeNode parent, Constant.FloatConstant floatConstant) {
        return this.visitConstant(parent, floatConstant);
    }

    public T visitBoxedFloatConstant(ByteCodeNode parent, Constant.BoxedFloatConstant boxedFloatConstant) {
        return this.visitConstant(parent, boxedFloatConstant);
    }

    public T visitLongConstant(ByteCodeNode parent, Constant.LongConstant longConstant) {
        return this.visitConstant(parent, longConstant);
    }

    public T visitBoxedLongConstant(ByteCodeNode parent, Constant.BoxedLongConstant boxedLongConstant) {
        return this.visitConstant(parent, boxedLongConstant);
    }

    public T visitDoubleConstant(ByteCodeNode parent, Constant.DoubleConstant doubleConstant) {
        return this.visitConstant(parent, doubleConstant);
    }

    public T visitBoxedDoubleConstant(ByteCodeNode parent, Constant.BoxedDoubleConstant boxedDoubleConstant) {
        return this.visitConstant(parent, boxedDoubleConstant);
    }

    public T visitStringConstant(ByteCodeNode parent, Constant.StringConstant stringConstant) {
        return this.visitConstant(parent, stringConstant);
    }

    public T visitClassConstant(ByteCodeNode parent, Constant.ClassConstant classConstant) {
        return this.visitConstant(parent, classConstant);
    }

    public T visitVariableInstruction(ByteCodeNode parent, VariableInstruction variableInstruction) {
        return this.visitInstruction(parent, variableInstruction);
    }

    public T visitLoadVariable(ByteCodeNode parent, VariableInstruction.LoadVariableInstruction loadVariableInstruction) {
        return this.visitVariableInstruction(parent, loadVariableInstruction);
    }

    public T visitStoreVariable(ByteCodeNode parent, VariableInstruction.StoreVariableInstruction storeVariableInstruction) {
        return this.visitVariableInstruction(parent, storeVariableInstruction);
    }

    public T visitIncrementVariable(ByteCodeNode parent, VariableInstruction.IncrementVariableInstruction incrementVariableInstruction) {
        return this.visitVariableInstruction(parent, incrementVariableInstruction);
    }

    public T visitFieldInstruction(ByteCodeNode parent, FieldInstruction fieldInstruction) {
        return this.visitInstruction(parent, fieldInstruction);
    }

    public T visitGetField(ByteCodeNode parent, FieldInstruction.GetFieldInstruction getFieldInstruction) {
        return this.visitFieldInstruction(parent, getFieldInstruction);
    }

    public T visitPutField(ByteCodeNode parent, FieldInstruction.PutFieldInstruction putFieldInstruction) {
        return this.visitFieldInstruction(parent, putFieldInstruction);
    }

    public T visitInvoke(ByteCodeNode parent, InvokeInstruction invokeInstruction) {
        return this.visitInstruction(parent, invokeInstruction);
    }

    public T visitInvokeDynamic(ByteCodeNode parent, InvokeInstruction.InvokeDynamicInstruction invokeDynamicInstruction) {
        return this.visitInvoke(parent, invokeDynamicInstruction);
    }

    public T visitDebug(ByteCodeNode parent, DebugNode debugNode) {
        return this.visitNode(parent, debugNode);
    }

    public T visitLineNumber(ByteCodeNode parent, LineNumberNode lineNumberNode) {
        return this.visitDebug(parent, lineNumberNode);
    }

    public T visitLocalVariable(ByteCodeNode parent, LocalVariableNode localVariableNode) {
        return this.visitDebug(parent, localVariableNode);
    }
}

