/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.spi.block.ArrayBlockEncoding;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.DictionaryBlockEncoding;
import com.facebook.presto.spi.block.FixedWidthBlockEncoding;
import com.facebook.presto.spi.block.InterleavedBlockEncoding;
import com.facebook.presto.spi.block.LazySliceArrayBlockEncoding;
import com.facebook.presto.spi.block.SliceArrayBlockEncoding;
import com.facebook.presto.spi.block.VariableWidthBlockEncoding;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.testing.RunLengthBlockEncoding;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public final class BlockEncodingManager
implements BlockEncodingSerde {
    private final TypeManager typeManager;
    private final ConcurrentMap<String, BlockEncodingFactory<?>> blockEncodings = new ConcurrentHashMap();

    public BlockEncodingManager(TypeManager typeManager, BlockEncodingFactory<?> ... blockEncodingFactories) {
        this(typeManager, (Set<BlockEncodingFactory<?>>)ImmutableSet.copyOf((Object[])blockEncodingFactories));
    }

    @Inject
    public BlockEncodingManager(TypeManager typeManager, Set<BlockEncodingFactory<?>> blockEncodingFactories) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.addBlockEncodingFactory(VariableWidthBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(FixedWidthBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(SliceArrayBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(LazySliceArrayBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(DictionaryBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(ArrayBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(InterleavedBlockEncoding.FACTORY);
        this.addBlockEncodingFactory(RunLengthBlockEncoding.FACTORY);
        for (BlockEncodingFactory<?> factory : Objects.requireNonNull(blockEncodingFactories, "blockEncodingFactories is null")) {
            this.addBlockEncodingFactory(factory);
        }
    }

    public void addBlockEncodingFactory(BlockEncodingFactory<?> blockEncoding) {
        Objects.requireNonNull(blockEncoding, "blockEncoding is null");
        BlockEncodingFactory<?> existingEntry = this.blockEncodings.putIfAbsent(blockEncoding.getName(), blockEncoding);
        Preconditions.checkArgument((existingEntry == null ? 1 : 0) != 0, (String)"Encoding %s is already registered", (Object[])new Object[]{blockEncoding.getName()});
    }

    public BlockEncoding readBlockEncoding(SliceInput input) {
        String encodingName = BlockEncodingManager.readLengthPrefixedString(input);
        BlockEncodingFactory blockEncoding = (BlockEncodingFactory)this.blockEncodings.get(encodingName);
        Preconditions.checkArgument((blockEncoding != null ? 1 : 0) != 0, (String)"Unknown block encoding %s", (Object[])new Object[]{encodingName});
        return blockEncoding.readEncoding(this.typeManager, (BlockEncodingSerde)this, input);
    }

    public void writeBlockEncoding(SliceOutput output, BlockEncoding encoding) {
        BlockEncodingManager.writeBlockEncodingInternal(output, encoding);
    }

    public static void writeBlockEncodingInternal(SliceOutput output, BlockEncoding encoding) {
        WriteOnlyBlockEncodingManager.INSTANCE.writeBlockEncoding(output, encoding);
    }

    private static String readLengthPrefixedString(SliceInput input) {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void writeLengthPrefixedString(SliceOutput output, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        output.writeInt(bytes.length);
        output.writeBytes(bytes);
    }

    private static class WriteOnlyBlockEncodingManager
    implements BlockEncodingSerde {
        static final WriteOnlyBlockEncodingManager INSTANCE = new WriteOnlyBlockEncodingManager();

        private WriteOnlyBlockEncodingManager() {
        }

        public BlockEncoding readBlockEncoding(SliceInput input) {
            throw new UnsupportedOperationException();
        }

        public void writeBlockEncoding(SliceOutput output, BlockEncoding encoding) {
            String encodingName = encoding.getName();
            BlockEncodingFactory blockEncoding = encoding.getFactory();
            BlockEncodingManager.writeLengthPrefixedString(output, encodingName);
            blockEncoding.writeEncoding((BlockEncodingSerde)this, output, encoding);
        }
    }
}

