/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.type.SqlType;
import io.airlift.jcodings.Encoding;
import io.airlift.jcodings.specific.NonStrictUTF8Encoding;
import io.airlift.joni.Regex;
import io.airlift.joni.Syntax;
import io.airlift.slice.Slice;
import java.nio.charset.StandardCharsets;

public final class LikeFunctions {
    private static final Syntax SYNTAX = new Syntax(0x800006, 0, 0, 0, new Syntax.MetaCharTable(92, 0, 0, 0, 0, 0));

    private LikeFunctions() {
    }

    @ScalarFunction(value="like", hidden=true)
    @SqlType(value="boolean")
    public static boolean like(@SqlType(value="varchar") Slice value, @SqlType(value="LikePattern") Regex pattern) {
        byte[] bytes = value.getBytes();
        return LikeFunctions.regexMatches(pattern, bytes);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="LikePattern")
    public static Regex likePattern(@SqlType(value="varchar") Slice pattern) {
        return LikeFunctions.likeToPattern(pattern.toStringUtf8(), '0', false);
    }

    @ScalarFunction
    @SqlType(value="LikePattern")
    public static Regex likePattern(@SqlType(value="varchar") Slice pattern, @SqlType(value="varchar") Slice escape) {
        return LikeFunctions.likeToPattern(pattern.toStringUtf8(), LikeFunctions.getEscapeChar(escape), true);
    }

    private static boolean regexMatches(Regex regex, byte[] bytes) {
        return regex.matcher(bytes).match(0, bytes.length, 0) != -1;
    }

    private static Regex likeToPattern(String patternString, char escapeChar, boolean shouldEscape) {
        StringBuilder regex = new StringBuilder(patternString.length() * 2);
        regex.append('^');
        boolean escaped = false;
        block7: for (char currentChar : patternString.toCharArray()) {
            if (shouldEscape && !escaped && currentChar == escapeChar) {
                escaped = true;
                continue;
            }
            switch (currentChar) {
                case '%': {
                    regex.append(escaped ? "%" : ".*");
                    escaped = false;
                    continue block7;
                }
                case '_': {
                    regex.append(escaped ? "_" : ".");
                    escaped = false;
                    continue block7;
                }
                default: {
                    switch (currentChar) {
                        case '$': 
                        case '*': 
                        case '.': 
                        case '\\': 
                        case '^': {
                            regex.append('\\');
                        }
                    }
                    regex.append(currentChar);
                    escaped = false;
                }
            }
        }
        regex.append('$');
        byte[] bytes = regex.toString().getBytes(StandardCharsets.UTF_8);
        return new Regex(bytes, 0, bytes.length, 4, (Encoding)NonStrictUTF8Encoding.INSTANCE, SYNTAX);
    }

    private static char getEscapeChar(Slice escape) {
        String escapeString = escape.toString(StandardCharsets.UTF_8);
        if (escapeString.isEmpty()) {
            return '\uffff';
        }
        if (escapeString.length() == 1) {
            return escapeString.charAt(0);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Escape must be empty or a single character");
    }
}

