/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.DateTimeUtils;
import com.facebook.presto.util.DateTimeZoneIndex;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.joda.time.chrono.ISOChronology;

public final class DateOperators {
    private DateOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="date") long left, @SqlType(value="date") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="date") long left, @SqlType(value="date") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="date") long left, @SqlType(value="date") long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="date") long left, @SqlType(value="date") long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="date") long left, @SqlType(value="date") long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="date") long left, @SqlType(value="date") long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="date") long value, @SqlType(value="date") long min, @SqlType(value="date") long max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="timestamp")
    public static long castToTimestamp(ConnectorSession session, @SqlType(value="date") long value) {
        long utcMillis = TimeUnit.DAYS.toMillis(value);
        ISOChronology chronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
        return utcMillis - (long)chronology.getZone().getOffset(utcMillis);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="timestamp with time zone")
    public static long castToTimestampWithTimeZone(ConnectorSession session, @SqlType(value="date") long value) {
        long utcMillis = TimeUnit.DAYS.toMillis(value);
        ISOChronology chronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
        long millis = utcMillis - (long)chronology.getZone().getOffset(utcMillis);
        return DateTimeEncoding.packDateTimeWithZone((long)millis, (TimeZoneKey)session.getTimeZoneKey());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castToSlice(@SqlType(value="date") long value) {
        return Slices.copiedBuffer((String)DateTimeUtils.printDate((int)value), (Charset)StandardCharsets.UTF_8);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="date")
    public static long castFromSlice(@SqlType(value="varchar") Slice value) {
        try {
            return DateTimeUtils.parseDate(SliceUtf8.trim((Slice)value).toStringUtf8());
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="date") long value) {
        return (int)value;
    }
}

