/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TestingConnectorSession
implements ConnectorSession {
    public static final ConnectorSession SESSION = new TestingConnectorSession((List<PropertyMetadata<?>>)ImmutableList.of());
    private final Identity identity;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final long startTime;
    private final Map<String, PropertyMetadata<?>> properties;
    private final Map<String, Object> propertyValues;

    public TestingConnectorSession(List<PropertyMetadata<?>> properties) {
        this("user", TimeZoneKey.UTC_KEY, Locale.ENGLISH, System.currentTimeMillis(), properties, (Map<String, Object>)ImmutableMap.of());
    }

    public TestingConnectorSession(String user, TimeZoneKey timeZoneKey, Locale locale, long startTime, List<PropertyMetadata<?>> propertyMetadatas, Map<String, Object> propertyValues) {
        this.identity = new Identity(Objects.requireNonNull(user, "user is null"), Optional.empty());
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.startTime = startTime;
        this.properties = Maps.uniqueIndex(propertyMetadatas, PropertyMetadata::getName);
        this.propertyValues = ImmutableMap.copyOf(propertyValues);
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public <T> T getProperty(String name, Class<T> type) {
        PropertyMetadata<?> metadata = this.properties.get(name);
        if (metadata == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + name);
        }
        Object value = this.propertyValues.get(name);
        if (value == null) {
            return type.cast(metadata.getDefaultValue());
        }
        return type.cast(metadata.decode(value));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("user", (Object)this.getUser()).add("timeZoneKey", (Object)this.timeZoneKey).add("locale", (Object)this.locale).add("startTime", this.startTime).add("properties", this.propertyValues).toString();
    }
}

