/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.InsertTableHandle;
import com.facebook.presto.metadata.OutputTableHandle;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableWriterNode
extends PlanNode {
    private final PlanNode source;
    private final WriterTarget target;
    private final List<Symbol> outputs;
    private final List<Symbol> columns;
    private final List<String> columnNames;
    private final Optional<Symbol> sampleWeightSymbol;

    @JsonCreator
    public TableWriterNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") WriterTarget target, @JsonProperty(value="columns") List<Symbol> columns, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="outputs") List<Symbol> outputs, @JsonProperty(value="sampleWeightSymbol") Optional<Symbol> sampleWeightSymbol) {
        super(id);
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        Preconditions.checkArgument((columns.size() == columnNames.size() ? 1 : 0) != 0, (Object)"columns and columnNames sizes don't match");
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.columns = ImmutableList.copyOf(columns);
        this.columnNames = ImmutableList.copyOf(columnNames);
        this.outputs = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputs, "outputs is null"));
        this.sampleWeightSymbol = Objects.requireNonNull(sampleWeightSymbol, "sampleWeightSymbol is null");
    }

    @JsonProperty
    public Optional<Symbol> getSampleWeightSymbol() {
        return this.sampleWeightSymbol;
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public WriterTarget getTarget() {
        return this.target;
    }

    @JsonProperty
    public List<Symbol> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    @JsonProperty(value="outputs")
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitTableWriter(this, context);
    }

    public static class DeleteHandle
    extends WriterTarget {
        private final TableHandle handle;

        @JsonCreator
        public DeleteHandle(@JsonProperty(value="handle") TableHandle handle) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
        }

        @JsonProperty
        public TableHandle getHandle() {
            return this.handle;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class InsertHandle
    extends WriterTarget {
        private final InsertTableHandle handle;

        @JsonCreator
        public InsertHandle(@JsonProperty(value="handle") InsertTableHandle handle) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
        }

        @JsonProperty
        public InsertTableHandle getHandle() {
            return this.handle;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class InsertReference
    extends WriterTarget {
        private final TableHandle handle;

        public InsertReference(TableHandle handle) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
        }

        public TableHandle getHandle() {
            return this.handle;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class CreateHandle
    extends WriterTarget {
        private final OutputTableHandle handle;

        @JsonCreator
        public CreateHandle(@JsonProperty(value="handle") OutputTableHandle handle) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
        }

        @JsonProperty
        public OutputTableHandle getHandle() {
            return this.handle;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class CreateName
    extends WriterTarget {
        private final String catalog;
        private final TableMetadata tableMetadata;

        public CreateName(String catalog, TableMetadata tableMetadata) {
            this.catalog = Objects.requireNonNull(catalog, "catalog is null");
            this.tableMetadata = Objects.requireNonNull(tableMetadata, "tableMetadata is null");
        }

        public String getCatalog() {
            return this.catalog;
        }

        public TableMetadata getTableMetadata() {
            return this.tableMetadata;
        }

        @Override
        public String toString() {
            return this.catalog + "." + this.tableMetadata.getTable();
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=CreateHandle.class, name="CreateHandle"), @JsonSubTypes.Type(value=InsertHandle.class, name="InsertHandle"), @JsonSubTypes.Type(value=DeleteHandle.class, name="DeleteHandle")})
    public static abstract class WriterTarget {
        public abstract String toString();
    }
}

